/*
 * Decompiled with CFR 0.152.
 */
package cn.cnaworld.framework.infrastructure.component.mybatisplus.handler;

import cn.cnaworld.framework.infrastructure.component.mybatisplus.handler.impl.FieldProcessor;
import cn.cnaworld.framework.infrastructure.properties.CnaworldMybatisPlusProperties;
import cn.cnaworld.framework.infrastructure.utils.log.CnaLogUtil;
import com.baomidou.mybatisplus.core.handlers.MetaObjectHandler;
import java.sql.Timestamp;
import java.time.LocalDateTime;
import java.util.Date;
import java.util.List;
import org.apache.commons.lang3.ObjectUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.ibatis.reflection.MetaObject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;

public class CustomizedMetaObjectHandler
implements MetaObjectHandler {
    private static final Logger log = LoggerFactory.getLogger(CustomizedMetaObjectHandler.class);
    @Autowired
    private CnaworldMybatisPlusProperties cnaworldMybatisPlusProperties;

    public void insertFill(MetaObject metaObject) {
        try {
            List<CnaworldMybatisPlusProperties.FillStrategyField> fillStrategyField;
            if (this.cnaworldMybatisPlusProperties != null && ObjectUtils.isNotEmpty(fillStrategyField = this.cnaworldMybatisPlusProperties.getFillStrategyField())) {
                fillStrategyField.forEach(t -> {
                    if (StringUtils.isNotBlank((CharSequence)t.getFieldName())) {
                        Object value = null;
                        if (ObjectUtils.isNotEmpty((Object)t.getFieldValue())) {
                            value = t.getFieldValue();
                        } else if (t.getFieldProcessorClass() != null) {
                            value = this.getFieldValueProcessor(t.getFieldName(), t.getFieldProcessorClass(), metaObject);
                        } else if (t.getFieldClass() != null) {
                            value = this.getFieldValue(t.getFieldClass());
                        }
                        if (ObjectUtils.isNotEmpty((Object)value)) {
                            this.fillStrategy(metaObject, t.getFieldName(), value);
                        }
                    }
                });
            }
        }
        catch (Exception e) {
            CnaLogUtil.error((Logger)log, (String)"cnaworld mybatis-plus auto-insert-fill error : {}", (Object[])new Object[]{e.getMessage(), e});
        }
    }

    public void updateFill(MetaObject metaObject) {
    }

    protected Object getFieldValue(Class<?> clazz) {
        if (!Long.TYPE.equals(clazz) && !Long.class.equals(clazz)) {
            if (!Integer.TYPE.equals(clazz) && !Integer.class.equals(clazz)) {
                if (Date.class.equals(clazz)) {
                    return new Date();
                }
                if (Timestamp.class.equals(clazz)) {
                    return new Timestamp(System.currentTimeMillis());
                }
                return LocalDateTime.class.equals(clazz) ? LocalDateTime.now() : null;
            }
            return 0;
        }
        return 0L;
    }

    private Object getFieldValueProcessor(String fieldName, Class<?> fieldProcessorClass, MetaObject metaObject) {
        Object obj;
        try {
            obj = fieldProcessorClass.newInstance();
        }
        catch (IllegalAccessException | InstantiationException e) {
            CnaLogUtil.error((Logger)log, (String)"cnaworld aop auto-insert-fill-processor-class \u89e3\u6790\u5931\u8d25 \uff1a{}", (Object[])new Object[]{fieldProcessorClass});
            return null;
        }
        if (!fieldProcessorClass.isInstance(obj)) {
            CnaLogUtil.error((Logger)log, (String)"cnaworld aop auto-insert-fill-processor-class \u89e3\u6790\u5931\u8d25 \uff1a{}", (Object[])new Object[]{fieldProcessorClass});
            return null;
        }
        FieldProcessor fieldProcessor = (FieldProcessor)obj;
        return fieldProcessor.getFieldValue(fieldName, metaObject);
    }
}

