/*
 * Decompiled with CFR 0.152.
 */
package cn.cnaworld.framework.infrastructure.component.mybatisplus.interceptor;

import cn.cnaworld.framework.infrastructure.component.mybatisplus.annotation.CnaFieldEncrypt;
import cn.cnaworld.framework.infrastructure.component.mybatisplus.processor.EncryptAlgorithmProcessor;
import cn.cnaworld.framework.infrastructure.component.mybatisplus.processor.booleanprocessor.impl.BooleanEncryptProcessor;
import cn.cnaworld.framework.infrastructure.component.mybatisplus.processor.dateprocessor.impl.DateEncryptProcessor;
import cn.cnaworld.framework.infrastructure.component.mybatisplus.processor.localdateprocessor.impl.LocalDateEncryptProcessor;
import cn.cnaworld.framework.infrastructure.component.mybatisplus.processor.numberprocessor.impl.NumberEncryptProcessor;
import cn.cnaworld.framework.infrastructure.component.mybatisplus.processor.stringprocessor.impl.AESEncryptProcessor;
import cn.cnaworld.framework.infrastructure.component.mybatisplus.statics.enums.EncryptAlgorithm;
import cn.cnaworld.framework.infrastructure.properties.CnaworldMybatisPlusProperties;
import cn.cnaworld.framework.infrastructure.utils.log.CnaLogUtil;
import cn.cnaworld.framework.infrastructure.utils.object.CnaObjectUtil;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.time.temporal.Temporal;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.commons.lang3.ObjectUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.ibatis.executor.Executor;
import org.apache.ibatis.mapping.MappedStatement;
import org.apache.ibatis.mapping.SqlCommandType;
import org.apache.ibatis.plugin.Interceptor;
import org.apache.ibatis.plugin.Intercepts;
import org.apache.ibatis.plugin.Invocation;
import org.apache.ibatis.plugin.Signature;
import org.apache.ibatis.session.ResultHandler;
import org.apache.ibatis.session.RowBounds;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;

@Intercepts(value={@Signature(type=Executor.class, method="update", args={MappedStatement.class, Object.class}), @Signature(type=Executor.class, method="query", args={MappedStatement.class, Object.class, RowBounds.class, ResultHandler.class})})
public class CnaworldAutoEncryptInterceptor
implements Interceptor {
    private static final Logger log = LoggerFactory.getLogger(CnaworldAutoEncryptInterceptor.class);
    @Autowired
    private CnaworldMybatisPlusProperties cnaworldMybatisPlusProperties;
    private static final Map<Class<?>, Map<Field, CnaFieldEncrypt>> ENTITY_FIELD_CACHE = new ConcurrentHashMap();
    private static final Map<String, EncryptAlgorithmProcessor> ENCRYPT_PROCESSOR_CACHE = new ConcurrentHashMap<String, EncryptAlgorithmProcessor>();

    public Object intercept(Invocation invocation) throws Throwable {
        Object[] args = invocation.getArgs();
        MappedStatement ms = (MappedStatement)args[0];
        if (SqlCommandType.SELECT == ms.getSqlCommandType()) {
            return this.handleRead(invocation);
        }
        if (SqlCommandType.UPDATE == ms.getSqlCommandType() || SqlCommandType.INSERT == ms.getSqlCommandType()) {
            this.handleWrite(args);
        }
        return invocation.proceed();
    }

    private void handleWrite(Object[] args) {
        Object parameterObject = args[1];
        if (CnaObjectUtil.notObject((Object)parameterObject)) {
            return;
        }
        Map<Field, CnaFieldEncrypt> fieldMap = this.getEntityFieldCache(parameterObject);
        if (parameterObject instanceof List) {
            List parameterList = (List)parameterObject;
            if (ObjectUtils.isNotEmpty((Object)parameterList)) {
                this.parameterListFor(fieldMap, parameterList);
            }
        } else if (parameterObject instanceof Map) {
            HashMap objMap = (HashMap)parameterObject;
            if (objMap.containsKey("et")) {
                Object parameter = objMap.get("et");
                this.fieldMapFor(fieldMap, parameter, 1);
            } else {
                Object parameter = objMap.getOrDefault("collection", null);
                List parameterList = parameter;
                if (ObjectUtils.isNotEmpty((Object)parameterList)) {
                    this.parameterListFor(fieldMap, parameterList);
                }
            }
        } else {
            this.fieldMapFor(fieldMap, parameterObject, 1);
        }
    }

    private void parameterListFor(Map<Field, CnaFieldEncrypt> fieldMap, List<?> parameterList) {
        parameterList.forEach(param -> this.fieldMapFor(fieldMap, param, 1));
    }

    private void fieldMapFor(Map<Field, CnaFieldEncrypt> fieldMap, Object parameterObject, int number) {
        if (fieldMap != null) {
            fieldMap.forEach((field, annotation) -> this.processor(parameterObject, (Field)field, (CnaFieldEncrypt)annotation, number));
        }
    }

    @Nullable
    private Object handleRead(Invocation invocation) throws InvocationTargetException, IllegalAccessException {
        Object proceed = invocation.proceed();
        if (CnaObjectUtil.notObject((Object)proceed)) {
            return proceed;
        }
        Map<Field, CnaFieldEncrypt> fieldMap = this.getEntityFieldCache(proceed);
        if (proceed instanceof List) {
            List resultList = (List)proceed;
            if (ObjectUtils.isNotEmpty((Object)resultList)) {
                resultList.forEach(result -> this.fieldMapFor(fieldMap, result, 2));
            }
        } else {
            this.fieldMapFor(fieldMap, proceed, 2);
        }
        return proceed;
    }

    private void processor(Object entity, Field field, CnaFieldEncrypt annotation, int encryptType) {
        if (CnaObjectUtil.isEmpty((Object)entity)) {
            return;
        }
        try {
            field.setAccessible(true);
            Object value = field.get(entity);
            if (ObjectUtils.isNotEmpty((Object)value)) {
                EncryptAlgorithmProcessor encryptAlgorithmProcessor = this.encryptAlgorithmProcessorFactory(annotation, value);
                String[] keys = this.getKeys(field, annotation);
                Object content = 1 == encryptType ? encryptAlgorithmProcessor.encrypt(value, keys) : encryptAlgorithmProcessor.decrypt(value, keys);
                if (!ObjectUtils.isEmpty((Object)content)) {
                    field.set(entity, content);
                }
            }
            field.setAccessible(false);
        }
        catch (ClassNotFoundException | IllegalAccessException | InstantiationException e) {
            throw new RuntimeException(e);
        }
    }

    private String[] getKeys(Field field, CnaFieldEncrypt annotation) {
        if (ObjectUtils.isNotEmpty((Object)annotation.keys())) {
            return annotation.keys();
        }
        if (ObjectUtils.isNotEmpty((Object)this.cnaworldMybatisPlusProperties.getFieldEncrypt()) && ObjectUtils.isNotEmpty((Object)this.cnaworldMybatisPlusProperties.getFieldEncrypt().getKeys())) {
            return this.cnaworldMybatisPlusProperties.getFieldEncrypt().getKeys();
        }
        CnaLogUtil.error((Logger)log, (String)"field:{},\u52a0\u5bc6\u89e3\u5bc6\u5931\u8d25\uff0c\u5bc6\u94a5\u672a\u914d\u7f6e", (Object[])new Object[]{field.getDeclaringClass() + "." + field.getName()});
        return null;
    }

    private EncryptAlgorithmProcessor encryptAlgorithmProcessorFactory(CnaFieldEncrypt annotation, Object value) throws InstantiationException, IllegalAccessException, ClassNotFoundException {
        EncryptAlgorithmProcessor encryptAlgorithmProcessor;
        EncryptAlgorithm algorithm = annotation.encryptAlgorithm();
        Class<? extends EncryptAlgorithmProcessor> aClass = annotation.encryptAlgorithmProcessor();
        if (EncryptAlgorithmProcessor.class != aClass) {
            if (ENCRYPT_PROCESSOR_CACHE.containsKey(aClass.getName())) {
                encryptAlgorithmProcessor = ENCRYPT_PROCESSOR_CACHE.get(aClass.getName());
            } else {
                encryptAlgorithmProcessor = aClass.newInstance();
                ENCRYPT_PROCESSOR_CACHE.put(aClass.getName(), encryptAlgorithmProcessor);
            }
        } else if (ObjectUtils.isNotEmpty((Object)this.cnaworldMybatisPlusProperties.getFieldEncrypt()) && ObjectUtils.isNotEmpty(this.cnaworldMybatisPlusProperties.getFieldEncrypt().getEncryptAlgorithmProcessor())) {
            if (ENCRYPT_PROCESSOR_CACHE.containsKey(this.cnaworldMybatisPlusProperties.getFieldEncrypt().getEncryptAlgorithmProcessor().getName())) {
                encryptAlgorithmProcessor = ENCRYPT_PROCESSOR_CACHE.get(this.cnaworldMybatisPlusProperties.getFieldEncrypt().getEncryptAlgorithmProcessor().getName());
            } else {
                encryptAlgorithmProcessor = this.cnaworldMybatisPlusProperties.getFieldEncrypt().getEncryptAlgorithmProcessor().newInstance();
                ENCRYPT_PROCESSOR_CACHE.put(this.cnaworldMybatisPlusProperties.getFieldEncrypt().getEncryptAlgorithmProcessor().getName(), encryptAlgorithmProcessor);
            }
        } else {
            encryptAlgorithmProcessor = algorithm.equals((Object)EncryptAlgorithm.NONE) ? (ObjectUtils.isEmpty((Object)this.cnaworldMybatisPlusProperties.getFieldEncrypt()) || ObjectUtils.isEmpty((Object)((Object)this.cnaworldMybatisPlusProperties.getFieldEncrypt().getAlgorithm())) ? this.getEncryptAlgorithmProcessor(null, value) : this.getEncryptAlgorithmProcessor(this.cnaworldMybatisPlusProperties.getFieldEncrypt().getAlgorithm().name(), value)) : this.getEncryptAlgorithmProcessor(algorithm.name(), value);
        }
        return encryptAlgorithmProcessor;
    }

    @NotNull
    private EncryptAlgorithmProcessor getEncryptAlgorithmProcessor(String name, Object value) throws ClassNotFoundException, InstantiationException, IllegalAccessException {
        EncryptAlgorithmProcessor encryptAlgorithmProcessor;
        if (value instanceof Number) {
            if (ENCRYPT_PROCESSOR_CACHE.containsKey(Number.class.getName())) {
                encryptAlgorithmProcessor = ENCRYPT_PROCESSOR_CACHE.get(Number.class.getName());
            } else {
                encryptAlgorithmProcessor = new NumberEncryptProcessor();
                ENCRYPT_PROCESSOR_CACHE.put(Number.class.getName(), encryptAlgorithmProcessor);
            }
        } else if (value instanceof Boolean) {
            if (ENCRYPT_PROCESSOR_CACHE.containsKey(Boolean.class.getName())) {
                encryptAlgorithmProcessor = ENCRYPT_PROCESSOR_CACHE.get(Boolean.class.getName());
            } else {
                encryptAlgorithmProcessor = new BooleanEncryptProcessor();
                ENCRYPT_PROCESSOR_CACHE.put(Boolean.class.getName(), encryptAlgorithmProcessor);
            }
        } else if (value instanceof Date) {
            if (ENCRYPT_PROCESSOR_CACHE.containsKey(Date.class.getName())) {
                encryptAlgorithmProcessor = ENCRYPT_PROCESSOR_CACHE.get(Date.class.getName());
            } else {
                encryptAlgorithmProcessor = new DateEncryptProcessor();
                ENCRYPT_PROCESSOR_CACHE.put(Date.class.getName(), encryptAlgorithmProcessor);
            }
        } else if (value instanceof Temporal) {
            if (ENCRYPT_PROCESSOR_CACHE.containsKey(Temporal.class.getName())) {
                encryptAlgorithmProcessor = ENCRYPT_PROCESSOR_CACHE.get(Temporal.class.getName());
            } else {
                encryptAlgorithmProcessor = new LocalDateEncryptProcessor();
                ENCRYPT_PROCESSOR_CACHE.put(Temporal.class.getName(), encryptAlgorithmProcessor);
            }
        } else if (value instanceof String) {
            if (StringUtils.isNotBlank((CharSequence)name)) {
                if (ENCRYPT_PROCESSOR_CACHE.containsKey(Temporal.class.getName() + name)) {
                    encryptAlgorithmProcessor = ENCRYPT_PROCESSOR_CACHE.get(Temporal.class.getName() + name);
                } else {
                    String encryptProcessor = "cn.cnaworld.framework.infrastructure.component.mybatisplus.processor.stringprocessor.impl." + name + "EncryptProcessor";
                    Class<?> encryptProcessorClass = Class.forName(encryptProcessor);
                    encryptAlgorithmProcessor = (EncryptAlgorithmProcessor)encryptProcessorClass.newInstance();
                    ENCRYPT_PROCESSOR_CACHE.put(String.class.getName() + name, encryptAlgorithmProcessor);
                }
            } else if (ENCRYPT_PROCESSOR_CACHE.containsKey(String.class.getName() + "aes")) {
                encryptAlgorithmProcessor = ENCRYPT_PROCESSOR_CACHE.get(String.class.getName() + "aes");
            } else {
                encryptAlgorithmProcessor = new AESEncryptProcessor();
                ENCRYPT_PROCESSOR_CACHE.put(String.class.getName() + "aes", encryptAlgorithmProcessor);
            }
        } else if (ENCRYPT_PROCESSOR_CACHE.containsKey(String.class.getName() + "aes")) {
            encryptAlgorithmProcessor = ENCRYPT_PROCESSOR_CACHE.get(String.class.getName() + "aes");
        } else {
            encryptAlgorithmProcessor = new AESEncryptProcessor();
            ENCRYPT_PROCESSOR_CACHE.put(String.class.getName() + "aes", encryptAlgorithmProcessor);
        }
        return encryptAlgorithmProcessor;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private Map<Field, CnaFieldEncrypt> getEntityFieldCache(Object obj) {
        Object o;
        if (ObjectUtils.isEmpty((Object)obj)) {
            return null;
        }
        Class<?> objClass = null;
        if (obj instanceof List) {
            List objList = (List)obj;
            if (ObjectUtils.isNotEmpty((Object)objList)) {
                o = objList.get(0);
                if (o instanceof Map) return null;
                objClass = objList.get(0).getClass();
            }
        } else if (obj instanceof Map) {
            List objList;
            HashMap objMap = (HashMap)obj;
            o = null;
            if (objMap.containsKey("et")) {
                o = objMap.get("et");
            } else if (objMap.containsKey("collection") && ObjectUtils.isNotEmpty((Object)(objList = (List)(o = (Object)objMap.get("collection"))))) {
                o = objList.get(0);
            }
            if (CnaObjectUtil.isEmpty(o)) {
                return null;
            }
            objClass = o.getClass();
        } else {
            objClass = obj.getClass();
        }
        if (ENTITY_FIELD_CACHE.containsKey(objClass)) return ENTITY_FIELD_CACHE.get(objClass);
        Field[] objFields = new Field[]{};
        if (objClass != null) {
            objFields = objClass.getDeclaredFields();
        }
        Map<Field, CnaFieldEncrypt> fieldMap = new HashMap<Field, CnaFieldEncrypt>();
        for (Field field : objFields) {
            CnaFieldEncrypt annotation = field.getAnnotation(CnaFieldEncrypt.class);
            if (annotation == null || !CnaObjectUtil.notObjectClass(field.getType())) continue;
            fieldMap.put(field, annotation);
        }
        if (!ObjectUtils.isNotEmpty(fieldMap)) return fieldMap;
        ENTITY_FIELD_CACHE.put(objClass, fieldMap);
        return fieldMap;
    }
}

