/*
 * Decompiled with CFR 0.152.
 */
package cn.cnaworld.framework.infrastructure.component.mybatisplus.processor.numberprocessor.impl;

import cn.cnaworld.framework.infrastructure.component.mybatisplus.processor.numberprocessor.NumberEncryptAlgorithmProcessor;
import java.math.BigDecimal;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class NumberEncryptProcessor
extends NumberEncryptAlgorithmProcessor {
    private static final Logger log = LoggerFactory.getLogger(NumberEncryptProcessor.class);

    @Override
    public Number encrypt(Number data, String ... keys) {
        return this.getNumber(data, keys, 1);
    }

    @Override
    public Number decrypt(Number data, String ... keys) {
        return this.getNumber(data, keys, 2);
    }

    @Nullable
    private Number getNumber(Number data, String[] keys, int encryptType) {
        if (!this.check(data, keys)) {
            return null;
        }
        if (data instanceof Integer) {
            return (Integer)data ^ this.getHashKey(keys);
        }
        if (data instanceof Long) {
            return (Long)data ^ (long)this.getHashKey(keys);
        }
        if (data instanceof Short) {
            return Short.parseShort(String.valueOf((Short)data ^ Short.parseShort(String.valueOf(this.getHashKey(keys)).substring(0, 4))));
        }
        if (data instanceof Byte) {
            return Byte.parseByte(String.valueOf((Byte)data ^ Byte.parseByte(String.valueOf(this.getHashKey(keys)).substring(0, 2))));
        }
        if (data instanceof Float) {
            return Float.valueOf(Float.intBitsToFloat(Float.floatToIntBits(((Float)data).floatValue()) ^ Integer.parseInt(String.valueOf(this.getHashKey(keys)).substring(0, 3))));
        }
        if (data instanceof Double) {
            return Double.longBitsToDouble(Double.doubleToLongBits((Double)data) ^ (long)this.getHashKey(keys));
        }
        if (data instanceof BigDecimal) {
            if (1 == encryptType) {
                return ((BigDecimal)data).add(new BigDecimal(String.valueOf(this.getHashKey(keys))));
            }
            return ((BigDecimal)data).subtract(new BigDecimal(String.valueOf(this.getHashKey(keys))));
        }
        return null;
    }
}

