/*
 * Decompiled with CFR 0.152.
 */
package cn.cnaworld.framework.infrastructure.component.mybatisplus.handler;

import cn.cnaworld.framework.infrastructure.component.mybatisplus.handler.impl.FieldProcessor;
import cn.cnaworld.framework.infrastructure.properties.CnaworldMybatisPlusProperties;
import cn.cnaworld.framework.infrastructure.utils.log.CnaLogUtil;
import cn.cnaworld.framework.infrastructure.utils.object.CnaCheckUtil;
import com.baomidou.mybatisplus.annotation.FieldFill;
import com.baomidou.mybatisplus.core.handlers.MetaObjectHandler;
import java.lang.reflect.Field;
import java.sql.Timestamp;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import javax.annotation.PostConstruct;
import org.apache.commons.lang3.ObjectUtils;
import org.apache.ibatis.reflection.MetaObject;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;

public class CustomizedMetaObjectHandler
implements MetaObjectHandler {
    private static final Logger log = LoggerFactory.getLogger(CustomizedMetaObjectHandler.class);
    @Autowired
    private CnaworldMybatisPlusProperties cnaworldMybatisPlusProperties;
    private static final Map<String, CnaworldMybatisPlusProperties.FillStrategyField> FIELD_CACHE = new HashMap<String, CnaworldMybatisPlusProperties.FillStrategyField>();
    private static final Map<String, Map<String, String>> CLASS_NAME_CACHE = new HashMap<String, Map<String, String>>();
    private static final Map<String, Map<String, String>> EXCLUDE_CLASS_NAME_CACHE = new HashMap<String, Map<String, String>>();
    private static final Map<Class<?>, FieldProcessor> PROCESSOR_OBJECT_CACHE = new ConcurrentHashMap();

    @PostConstruct
    public void init() {
        List<CnaworldMybatisPlusProperties.FillStrategyField> fillStrategyField = this.cnaworldMybatisPlusProperties.getFillStrategyField();
        if (ObjectUtils.isNotEmpty(fillStrategyField)) {
            fillStrategyField.forEach(t -> {
                if (CnaCheckUtil.isNotNull((Object)t.getFieldFullName())) {
                    FIELD_CACHE.put(t.getFieldFullName(), (CnaworldMybatisPlusProperties.FillStrategyField)t);
                } else if (CnaCheckUtil.isNotNull((Object)t.getRangeFill()) && CnaCheckUtil.isNotNull((Object)t.getRangeFill().getFieldName())) {
                    FIELD_CACHE.put(t.getRangeFill().getFieldName(), (CnaworldMybatisPlusProperties.FillStrategyField)t);
                    if (CnaCheckUtil.isNotNull(t.getRangeFill().getIncludeClass())) {
                        HashMap includeClass = new HashMap();
                        t.getRangeFill().getIncludeClass().forEach(s -> includeClass.put(s, s));
                        CLASS_NAME_CACHE.put(t.getRangeFill().getFieldName(), includeClass);
                    }
                    if (CnaCheckUtil.isNotNull(t.getRangeFill().getExcludeClass())) {
                        HashMap excludeClass = new HashMap();
                        t.getRangeFill().getExcludeClass().forEach(s -> excludeClass.put(s, s));
                        EXCLUDE_CLASS_NAME_CACHE.put(t.getRangeFill().getFieldName(), excludeClass);
                    }
                }
            });
        }
    }

    public void insertFill(MetaObject metaObject) {
        try {
            List<Field> fieldList = CustomizedMetaObjectHandler.getFieldList(metaObject);
            String className = metaObject.getOriginalObject().getClass().getName();
            if (CnaCheckUtil.isNotNull(fieldList)) {
                for (Field field : fieldList) {
                    Object value;
                    CnaworldMybatisPlusProperties.FillStrategyField fillStrategyField;
                    if (!CnaCheckUtil.isNotObjectClass(field.getType())) continue;
                    String name = field.getName();
                    String classAllName = className + "." + name;
                    if (FIELD_CACHE.containsKey(classAllName)) {
                        this.fillValueByName(metaObject, name, classAllName);
                        continue;
                    }
                    if (!FIELD_CACHE.containsKey(name) || (fillStrategyField = CustomizedMetaObjectHandler.getFillStrategyField(className, name)) == null || !CnaCheckUtil.isNotNull((Object)fillStrategyField.getFillType()) || !fillStrategyField.getFillType().equals((Object)FieldFill.INSERT) && !fillStrategyField.getFillType().equals((Object)FieldFill.INSERT_UPDATE) || !ObjectUtils.isNotEmpty((Object)(value = this.getValue(metaObject, fillStrategyField)))) continue;
                    this.fillStrategy(metaObject, name, value);
                }
            }
        }
        catch (Exception e) {
            CnaLogUtil.error((Logger)log, (String)"cnaworld mybatis-plus auto-insert-fill error : {}", (Object[])new Object[]{e.getMessage(), e});
        }
    }

    public void updateFill(MetaObject metaObject) {
        try {
            List<Field> fieldList = CustomizedMetaObjectHandler.getFieldList(metaObject);
            String className = metaObject.getOriginalObject().getClass().getName();
            if (CnaCheckUtil.isNotNull(fieldList)) {
                for (Field field : fieldList) {
                    Object value;
                    CnaworldMybatisPlusProperties.FillStrategyField fillStrategyField;
                    if (!CnaCheckUtil.isNotObjectClass(field.getType())) continue;
                    String name = field.getName();
                    String classAllName = className + name;
                    if (FIELD_CACHE.containsKey(classAllName)) {
                        this.fillValueByName(metaObject, name, classAllName);
                        continue;
                    }
                    if (!FIELD_CACHE.containsKey(name) || (fillStrategyField = CustomizedMetaObjectHandler.getFillStrategyField(className, name)) == null || !CnaCheckUtil.isNotNull((Object)fillStrategyField.getFillType()) || !fillStrategyField.getFillType().equals((Object)FieldFill.UPDATE) && !fillStrategyField.getFillType().equals((Object)FieldFill.INSERT_UPDATE) || !ObjectUtils.isNotEmpty((Object)(value = this.getValue(metaObject, fillStrategyField)))) continue;
                    this.fillStrategy(metaObject, name, value);
                }
            }
        }
        catch (Exception e) {
            CnaLogUtil.error((Logger)log, (String)"cnaworld mybatis-plus auto-insert-fill error : {}", (Object[])new Object[]{e.getMessage(), e});
        }
    }

    @Nullable
    private static CnaworldMybatisPlusProperties.FillStrategyField getFillStrategyField(String className, String name) {
        Map<String, String> classAllNameTmp;
        Map<String, String> excludeClassAllName;
        CnaworldMybatisPlusProperties.FillStrategyField fillStrategyField = FIELD_CACHE.get(name);
        if (EXCLUDE_CLASS_NAME_CACHE.containsKey(name) && (excludeClassAllName = EXCLUDE_CLASS_NAME_CACHE.get(name)).containsKey(className)) {
            return null;
        }
        if (CLASS_NAME_CACHE.containsKey(name) && !(classAllNameTmp = CLASS_NAME_CACHE.get(name)).containsKey(className)) {
            return null;
        }
        return fillStrategyField;
    }

    private void fillValueByName(MetaObject metaObject, String name, String classAllName) {
        Object value;
        CnaworldMybatisPlusProperties.FillStrategyField fillStrategyField = FIELD_CACHE.get(classAllName);
        if (CnaCheckUtil.isNotNull((Object)fillStrategyField.getFillType()) && (fillStrategyField.getFillType().equals((Object)FieldFill.INSERT) || fillStrategyField.getFillType().equals((Object)FieldFill.INSERT_UPDATE)) && ObjectUtils.isNotEmpty((Object)(value = this.getValue(metaObject, fillStrategyField)))) {
            this.fillStrategy(metaObject, name, value);
        }
    }

    @NotNull
    private static List<Field> getFieldList(MetaObject metaObject) {
        ArrayList<Field> fieldList = new ArrayList<Field>();
        for (Class<?> tempClass = metaObject.getOriginalObject().getClass(); tempClass != null; tempClass = tempClass.getSuperclass()) {
            fieldList.addAll(Arrays.asList(tempClass.getDeclaredFields()));
        }
        return fieldList;
    }

    @Nullable
    private Object getValue(MetaObject metaObject, CnaworldMybatisPlusProperties.FillStrategyField t) {
        Object value = null;
        if (ObjectUtils.isNotEmpty((Object)t.getFieldValue())) {
            value = t.getFieldValue();
        } else if (t.getFieldProcessorClass() != null) {
            String fileName = "";
            if (CnaCheckUtil.isNotNull((Object)t.getFieldFullName())) {
                fileName = t.getFieldFullName();
            } else if (CnaCheckUtil.isNotNull((Object)t.getRangeFill()) && CnaCheckUtil.isNotNull((Object)t.getRangeFill().getFieldName())) {
                fileName = t.getRangeFill().getFieldName();
            }
            value = this.getFieldValueProcessor(fileName, t.getFieldProcessorClass(), metaObject);
        } else if (t.getFieldClass() != null) {
            value = this.getFieldValue(t.getFieldClass());
        }
        return value;
    }

    protected Object getFieldValue(Class<?> clazz) {
        if (!Long.TYPE.equals(clazz) && !Long.class.equals(clazz)) {
            if (!Integer.TYPE.equals(clazz) && !Integer.class.equals(clazz)) {
                if (Date.class.equals(clazz)) {
                    return new Date();
                }
                if (Timestamp.class.equals(clazz)) {
                    return new Timestamp(System.currentTimeMillis());
                }
                return LocalDateTime.class.equals(clazz) ? LocalDateTime.now() : null;
            }
            return 0;
        }
        return 0L;
    }

    private Object getFieldValueProcessor(String fieldName, Class<?> fieldProcessorClass, MetaObject metaObject) {
        FieldProcessor fieldProcessor;
        if (PROCESSOR_OBJECT_CACHE.containsKey(fieldProcessorClass)) {
            fieldProcessor = PROCESSOR_OBJECT_CACHE.get(fieldProcessorClass);
        } else {
            Object obj;
            try {
                obj = fieldProcessorClass.newInstance();
            }
            catch (IllegalAccessException | InstantiationException e) {
                CnaLogUtil.error((Logger)log, (String)"cnaworld aop auto-insert-fill-processor-class \u89e3\u6790\u5931\u8d25 \uff1a{}", (Object[])new Object[]{fieldProcessorClass});
                return null;
            }
            if (!fieldProcessorClass.isInstance(obj)) {
                CnaLogUtil.error((Logger)log, (String)"cnaworld aop auto-insert-fill-processor-class \u89e3\u6790\u5931\u8d25 \uff1a{}", (Object[])new Object[]{fieldProcessorClass});
                return null;
            }
            fieldProcessor = (FieldProcessor)obj;
            PROCESSOR_OBJECT_CACHE.put(fieldProcessorClass, fieldProcessor);
        }
        return fieldProcessor.getFieldValue(fieldName, metaObject);
    }
}

