/*
 * Decompiled with CFR 0.152.
 */
package cn.cnaworld.framework.infrastructure.component.mybatisplus.handler;

import cn.cnaworld.framework.infrastructure.component.mybatisplus.handler.impl.FieldProcessor;
import cn.cnaworld.framework.infrastructure.component.mybatisplus.handler.vo.FillValueVo;
import cn.cnaworld.framework.infrastructure.properties.CnaworldMybatisPlusProperties;
import cn.cnaworld.framework.infrastructure.utils.log.CnaLogUtil;
import cn.cnaworld.framework.infrastructure.utils.object.CnaCheckUtil;
import com.baomidou.mybatisplus.annotation.FieldFill;
import com.baomidou.mybatisplus.core.handlers.MetaObjectHandler;
import java.lang.reflect.Field;
import java.sql.Timestamp;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import javax.annotation.PostConstruct;
import org.apache.commons.lang3.ObjectUtils;
import org.apache.ibatis.reflection.MetaObject;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;

public class CustomizedMetaObjectHandler
implements MetaObjectHandler {
    private static final Logger log = LoggerFactory.getLogger(CustomizedMetaObjectHandler.class);
    @Autowired
    private CnaworldMybatisPlusProperties cnaworldMybatisPlusProperties;
    private static final Map<String, CnaworldMybatisPlusProperties.FillStrategyField> FIELD_CACHE = new HashMap<String, CnaworldMybatisPlusProperties.FillStrategyField>();
    private static final Map<String, Map<Class<?>, Class<?>>> CLASS_NAME_CACHE = new HashMap();
    private static final Map<String, Map<Class<?>, Class<?>>> EXCLUDE_CLASS_NAME_CACHE = new HashMap();
    private static final Map<Class<?>, FieldProcessor> PROCESSOR_OBJECT_CACHE = new ConcurrentHashMap();
    private static final Map<String, List<FillValueVo>> INSERT_FILL_CACHE = new ConcurrentHashMap<String, List<FillValueVo>>();
    private static final Map<String, List<FillValueVo>> UPDATE_FILL_CACHE = new ConcurrentHashMap<String, List<FillValueVo>>();

    @PostConstruct
    public void init() {
        List<CnaworldMybatisPlusProperties.FillStrategyField> fillStrategyField = this.cnaworldMybatisPlusProperties.getFillStrategyField();
        if (ObjectUtils.isNotEmpty(fillStrategyField)) {
            fillStrategyField.forEach(t -> {
                if (CnaCheckUtil.isNotNull((Object)t.getFieldFullName())) {
                    FIELD_CACHE.put(t.getFieldFullName(), (CnaworldMybatisPlusProperties.FillStrategyField)t);
                } else if (CnaCheckUtil.isNotNull((Object)t.getRangeFill()) && CnaCheckUtil.isNotNull(t.getRangeFill().getFieldNames())) {
                    t.getRangeFill().getFieldNames().forEach(s -> {
                        FIELD_CACHE.put((String)s, (CnaworldMybatisPlusProperties.FillStrategyField)t);
                        if (CnaCheckUtil.isNotNull(t.getRangeFill().getIncludeClass())) {
                            HashMap includeClass = new HashMap();
                            t.getRangeFill().getIncludeClass().forEach(s1 -> includeClass.put(s1, s1));
                            CLASS_NAME_CACHE.put((String)s, includeClass);
                        }
                        if (CnaCheckUtil.isNotNull(t.getRangeFill().getExcludeClass())) {
                            HashMap excludeClass = new HashMap();
                            t.getRangeFill().getExcludeClass().forEach(s1 -> excludeClass.put(s1, s1));
                            EXCLUDE_CLASS_NAME_CACHE.put((String)s, excludeClass);
                        }
                    });
                }
            });
        }
    }

    public void insertFill(MetaObject metaObject) {
        try {
            Class<?> clazz = metaObject.getOriginalObject().getClass();
            String className = clazz.getName();
            List<Object> fillValueVos = new ArrayList();
            if (INSERT_FILL_CACHE.containsKey(className)) {
                fillValueVos = INSERT_FILL_CACHE.get(className);
                fillValueVos.forEach(t -> {
                    Object value = CnaCheckUtil.isNotNull((Object)t.getClassFullName()) ? this.getValue(metaObject, t.getFillStrategyField(), t.getClassFullName()) : this.getValue(metaObject, t.getFillStrategyField(), t.getName());
                    this.fillStrategy(metaObject, t.getName(), value);
                });
            } else {
                List<Field> fieldList = CustomizedMetaObjectHandler.getFieldList(metaObject);
                if (CnaCheckUtil.isNotNull(fieldList)) {
                    for (Field field : fieldList) {
                        FillValueVo fillValueVo;
                        Object value;
                        CnaworldMybatisPlusProperties.FillStrategyField fillStrategyField;
                        if (!CnaCheckUtil.isNotObjectClass(field.getType())) continue;
                        String name = field.getName();
                        String classFullName = className + "." + name;
                        if (FIELD_CACHE.containsKey(classFullName)) {
                            fillStrategyField = FIELD_CACHE.get(classFullName);
                            if (!CnaCheckUtil.isNotNull((Object)fillStrategyField.getFillType()) || !fillStrategyField.getFillType().equals((Object)FieldFill.INSERT) && !fillStrategyField.getFillType().equals((Object)FieldFill.INSERT_UPDATE)) continue;
                            value = this.getValue(metaObject, fillStrategyField, classFullName);
                            fillValueVo = new FillValueVo();
                            fillValueVo.setFillStrategyField(fillStrategyField);
                            fillValueVo.setClassFullName(classFullName);
                            fillValueVo.setName(name);
                            fillValueVos.add(fillValueVo);
                            if (!ObjectUtils.isNotEmpty((Object)value)) continue;
                            this.fillStrategy(metaObject, name, value);
                            continue;
                        }
                        if (!FIELD_CACHE.containsKey(name) || (fillStrategyField = CustomizedMetaObjectHandler.getFillStrategyField(clazz, name)) == null || !CnaCheckUtil.isNotNull((Object)fillStrategyField.getFillType()) || !fillStrategyField.getFillType().equals((Object)FieldFill.INSERT) && !fillStrategyField.getFillType().equals((Object)FieldFill.INSERT_UPDATE)) continue;
                        value = this.getValue(metaObject, fillStrategyField, name);
                        fillValueVo = new FillValueVo();
                        fillValueVo.setFillStrategyField(fillStrategyField);
                        fillValueVo.setName(name);
                        fillValueVos.add(fillValueVo);
                        if (!ObjectUtils.isNotEmpty((Object)value)) continue;
                        this.fillStrategy(metaObject, name, value);
                    }
                    if (CnaCheckUtil.isNotNull(fillValueVos)) {
                        INSERT_FILL_CACHE.put(className, fillValueVos);
                    }
                }
            }
        }
        catch (Exception e) {
            CnaLogUtil.error((Logger)log, (String)"cnaworld mybatis-plus auto-insert-fill error : {}", (Object[])new Object[]{e.getMessage(), e});
        }
    }

    public void updateFill(MetaObject metaObject) {
        try {
            Class<?> clazz = metaObject.getOriginalObject().getClass();
            String className = clazz.getName();
            List<Object> fillValueVos = new ArrayList();
            if (UPDATE_FILL_CACHE.containsKey(className)) {
                fillValueVos = UPDATE_FILL_CACHE.get(className);
                fillValueVos.forEach(t -> {
                    Object value = CnaCheckUtil.isNotNull((Object)t.getClassFullName()) ? this.getValue(metaObject, t.getFillStrategyField(), t.getClassFullName()) : this.getValue(metaObject, t.getFillStrategyField(), t.getName());
                    this.setFieldValByName(t.getName(), value, metaObject);
                });
            } else {
                List<Field> fieldList = CustomizedMetaObjectHandler.getFieldList(metaObject);
                if (CnaCheckUtil.isNotNull(fieldList)) {
                    for (Field field : fieldList) {
                        FillValueVo fillValueVo;
                        Object value;
                        CnaworldMybatisPlusProperties.FillStrategyField fillStrategyField;
                        if (!CnaCheckUtil.isNotObjectClass(field.getType())) continue;
                        String name = field.getName();
                        String classFullName = className + "." + name;
                        if (FIELD_CACHE.containsKey(classFullName)) {
                            fillStrategyField = FIELD_CACHE.get(classFullName);
                            if (!CnaCheckUtil.isNotNull((Object)fillStrategyField.getFillType()) || !fillStrategyField.getFillType().equals((Object)FieldFill.INSERT) && !fillStrategyField.getFillType().equals((Object)FieldFill.INSERT_UPDATE)) continue;
                            value = this.getValue(metaObject, fillStrategyField, classFullName);
                            fillValueVo = new FillValueVo();
                            fillValueVo.setFillStrategyField(fillStrategyField);
                            fillValueVo.setClassFullName(classFullName);
                            fillValueVo.setName(name);
                            fillValueVos.add(fillValueVo);
                            if (!ObjectUtils.isNotEmpty((Object)value)) continue;
                            this.setFieldValByName(name, value, metaObject);
                            continue;
                        }
                        if (!FIELD_CACHE.containsKey(name) || (fillStrategyField = CustomizedMetaObjectHandler.getFillStrategyField(clazz, name)) == null || !CnaCheckUtil.isNotNull((Object)fillStrategyField.getFillType()) || !fillStrategyField.getFillType().equals((Object)FieldFill.UPDATE) && !fillStrategyField.getFillType().equals((Object)FieldFill.INSERT_UPDATE)) continue;
                        value = this.getValue(metaObject, fillStrategyField, name);
                        fillValueVo = new FillValueVo();
                        fillValueVo.setFillStrategyField(fillStrategyField);
                        fillValueVo.setName(name);
                        fillValueVos.add(fillValueVo);
                        if (!ObjectUtils.isNotEmpty((Object)value)) continue;
                        this.setFieldValByName(name, value, metaObject);
                    }
                    if (CnaCheckUtil.isNotNull(fillValueVos)) {
                        UPDATE_FILL_CACHE.put(className, fillValueVos);
                    }
                }
            }
        }
        catch (Exception e) {
            CnaLogUtil.error((Logger)log, (String)"cnaworld mybatis-plus auto-insert-fill error : {}", (Object[])new Object[]{e.getMessage(), e});
        }
    }

    @Nullable
    private static CnaworldMybatisPlusProperties.FillStrategyField getFillStrategyField(Class<?> clazz, String name) {
        Map<Class<?>, Class<?>> classAllNameTmp;
        Map<Class<?>, Class<?>> excludeClassAllName;
        CnaworldMybatisPlusProperties.FillStrategyField fillStrategyField = FIELD_CACHE.get(name);
        if (EXCLUDE_CLASS_NAME_CACHE.containsKey(name) && (excludeClassAllName = EXCLUDE_CLASS_NAME_CACHE.get(name)).containsKey(clazz)) {
            return null;
        }
        if (CLASS_NAME_CACHE.containsKey(name) && !(classAllNameTmp = CLASS_NAME_CACHE.get(name)).containsKey(clazz)) {
            return null;
        }
        return fillStrategyField;
    }

    @NotNull
    private static List<Field> getFieldList(MetaObject metaObject) {
        ArrayList<Field> fieldList = new ArrayList<Field>();
        for (Class<?> tempClass = metaObject.getOriginalObject().getClass(); tempClass != null; tempClass = tempClass.getSuperclass()) {
            fieldList.addAll(Arrays.asList(tempClass.getDeclaredFields()));
        }
        return fieldList;
    }

    @Nullable
    private Object getValue(MetaObject metaObject, CnaworldMybatisPlusProperties.FillStrategyField t, String fileName) {
        Object value = null;
        if (ObjectUtils.isNotEmpty((Object)t.getFieldValue())) {
            value = t.getFieldValue();
        } else if (t.getFieldProcessorClass() != null) {
            value = this.getFieldValueProcessor(fileName, t.getFieldProcessorClass(), metaObject);
        } else if (t.getFieldClass() != null) {
            value = this.getFieldValue(t.getFieldClass());
        }
        return value;
    }

    protected Object getFieldValue(Class<?> clazz) {
        if (Boolean.TYPE.equals(clazz) || Boolean.class.equals(clazz)) {
            return false;
        }
        if (Long.TYPE.equals(clazz) || Long.class.equals(clazz)) {
            return 0L;
        }
        if (Integer.TYPE.equals(clazz) || Integer.class.equals(clazz)) {
            return 0;
        }
        if (Date.class.equals(clazz)) {
            return new Date();
        }
        if (Timestamp.class.equals(clazz)) {
            return new Timestamp(System.currentTimeMillis());
        }
        if (LocalDateTime.class.equals(clazz)) {
            return LocalDateTime.now();
        }
        return null;
    }

    private Object getFieldValueProcessor(String fieldName, Class<?> fieldProcessorClass, MetaObject metaObject) {
        FieldProcessor fieldProcessor;
        if (PROCESSOR_OBJECT_CACHE.containsKey(fieldProcessorClass)) {
            fieldProcessor = PROCESSOR_OBJECT_CACHE.get(fieldProcessorClass);
        } else {
            Object obj;
            try {
                obj = fieldProcessorClass.newInstance();
            }
            catch (IllegalAccessException | InstantiationException e) {
                CnaLogUtil.error((Logger)log, (String)"cnaworld aop auto-insert-fill-processor-class \u89e3\u6790\u5931\u8d25 \uff1a{}", (Object[])new Object[]{fieldProcessorClass});
                return null;
            }
            if (!fieldProcessorClass.isInstance(obj)) {
                CnaLogUtil.error((Logger)log, (String)"cnaworld aop auto-insert-fill-processor-class \u89e3\u6790\u5931\u8d25 \uff1a{}", (Object[])new Object[]{fieldProcessorClass});
                return null;
            }
            fieldProcessor = (FieldProcessor)obj;
            PROCESSOR_OBJECT_CACHE.put(fieldProcessorClass, fieldProcessor);
        }
        return fieldProcessor.getFieldValue(fieldName, metaObject);
    }
}

