/*
 * Decompiled with CFR 0.152.
 */
package cn.cnaworld.framework.infrastructure.component.mybatisplus.processor.localdateprocessor.impl;

import cn.cnaworld.framework.infrastructure.component.mybatisplus.processor.localdateprocessor.LocalDateEncryptAlgorithmProcessor;
import java.time.Instant;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.ZoneOffset;
import java.time.temporal.Temporal;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LocalDateEncryptProcessor
extends LocalDateEncryptAlgorithmProcessor {
    private static final Logger log = LoggerFactory.getLogger(LocalDateEncryptProcessor.class);

    @Override
    public Temporal encrypt(Temporal data, String ... keys) {
        return this.getTemporal(data, keys);
    }

    @Override
    public Temporal decrypt(Temporal data, String ... keys) {
        return this.getTemporal(data, keys);
    }

    @Nullable
    private Temporal getTemporal(Temporal data, String[] keys) {
        if (!this.check(data, keys)) {
            return null;
        }
        if (data instanceof LocalDate) {
            long timestamp = ((LocalDate)data).atStartOfDay().toInstant(ZoneOffset.of("+8")).toEpochMilli() ^ (long)this.getHashKey(keys);
            return LocalDateTime.ofInstant(Instant.ofEpochMilli(timestamp), ZoneOffset.of("+8")).toLocalDate();
        }
        if (data instanceof LocalDateTime) {
            long timestamp = ((LocalDateTime)data).toInstant(ZoneOffset.of("+8")).toEpochMilli() ^ (long)this.getHashKey(keys);
            return LocalDateTime.ofInstant(Instant.ofEpochMilli(timestamp), ZoneOffset.of("+8"));
        }
        return null;
    }
}

