/*
 * Decompiled with CFR 0.152.
 */
package cn.com.anysdk.core.log;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.slf4j.MDC;

public class OperationLogger {
    private static final Logger log = LoggerFactory.getLogger(OperationLogger.class);
    private static final String OPERATION_TYPE = "operationType";
    private static final String SERVICE = "service";
    private static final String PATH = "path";
    private static final String DURATION = "duration";
    private static final String SIZE = "size";
    private static final String IS_PRIVATE = "isPrivate";
    private static final String REQUEST_ID = "requestId";

    public static void logOperationStart(String methodName, String module, String description) {
        log.info("Operation started - Method: {}, Module: {}, Description: {}", new Object[]{methodName, module, description});
    }

    public static void logOperationStart(String methodName, String module, String description, String params) {
        log.info("Operation started - Method: {}, Module: {}, Description: {}, Params: {}", new Object[]{methodName, module, description, params});
    }

    public static void logOperationEnd(long duration, String requestId) {
        log.info("Operation completed - Duration: {}ms, RequestId: {}", (Object)duration, (Object)requestId);
    }

    public static void logOperationEnd(long duration, String result, String requestId) {
        log.info("Operation completed - Duration: {}ms, Result: {}, RequestId: {}", new Object[]{duration, result, requestId});
    }

    public static void logOperationEnd(long duration, long size, boolean isPrivate, String requestId) {
        MDC.put((String)DURATION, (String)String.valueOf(duration));
        MDC.put((String)SIZE, (String)String.valueOf(size));
        MDC.put((String)IS_PRIVATE, (String)String.valueOf(isPrivate));
        MDC.put((String)REQUEST_ID, (String)requestId);
        log.info("Operation completed - Duration: {}ms, Size: {}bytes, Private: {}, RequestId: {}", new Object[]{duration, size, isPrivate, requestId});
        OperationLogger.clearContext();
    }

    public static void logOperationError(String message, Throwable e) {
        log.error("Operation failed - Error: {}", (Object)message, (Object)e);
    }

    private static void clearContext() {
        MDC.remove((String)OPERATION_TYPE);
        MDC.remove((String)SERVICE);
        MDC.remove((String)PATH);
        MDC.remove((String)DURATION);
        MDC.remove((String)SIZE);
        MDC.remove((String)IS_PRIVATE);
        MDC.remove((String)REQUEST_ID);
    }
}

