package cn.com.anysdk.core.annotation;

import java.lang.annotation.*;
import java.util.concurrent.TimeUnit;

/**
 * 异步任务注解
 * 用于标记需要异步执行的方法
 */
@Target({ElementType.METHOD})
@Retention(RetentionPolicy.RUNTIME)
@Documented
public @interface AsyncTask {
    /**
     * 任务名称
     */
    String name() default "";

    /**
     * 任务描述
     */
    String description() default "";

    /**
     * 重试次数
     */
    int retryTimes() default 0;

    /**
     * 重试间隔
     */
    long retryInterval() default 0;

    /**
     * 重试间隔时间单位
     */
    TimeUnit retryIntervalUnit() default TimeUnit.SECONDS;

    /**
     * 超时时间
     */
    long timeout() default 0;

    /**
     * 超时时间单位
     */
    TimeUnit timeoutUnit() default TimeUnit.SECONDS;
}