package cn.com.anysdk.core.annotation;

import java.lang.annotation.*;
import java.util.concurrent.TimeUnit;

/**
 * 缓存注解
 * 用于标记需要缓存的方法
 */
@Target({ElementType.METHOD})
@Retention(RetentionPolicy.RUNTIME)
@Documented
public @interface Cache {
    /**
     * 缓存键前缀
     */
    String prefix() default "";

    /**
     * 缓存键
     */
    String key() default "";

    /**
     * 缓存过期时间
     */
    long expire() default 0;

    /**
     * 缓存过期时间单位
     */
    TimeUnit expireUnit() default TimeUnit.SECONDS;

    /**
     * 是否缓存空值
     */
    boolean cacheNull() default false;

    /**
     * 缓存类型
     */
    CacheType type() default CacheType.LOCAL;

    /**
     * 缓存类型枚举
     */
    enum CacheType {
        /**
         * 本地缓存
         */
        LOCAL,
        /**
         * 分布式缓存
         */
        DISTRIBUTED
    }
}