package cn.com.anysdk.core.annotation;

import java.lang.annotation.*;

/**
 * 敏感数据注解
 * 用于标记需要脱敏的字段
 */
@Target({ElementType.FIELD})
@Retention(RetentionPolicy.RUNTIME)
@Documented
public @interface Sensitive {
    /**
     * 脱敏类型
     */
    SensitiveType type() default SensitiveType.DEFAULT;

    /**
     * 脱敏类型枚举
     */
    enum SensitiveType {
        /**
         * 默认脱敏
         */
        DEFAULT,
        /**
         * 手机号脱敏
         */
        PHONE,
        /**
         * 身份证号脱敏
         */
        ID_CARD,
        /**
         * 银行卡号脱敏
         */
        BANK_CARD,
        /**
         * 邮箱脱敏
         */
        EMAIL,
        /**
         * 密码脱敏
         */
        PASSWORD,
        /**
         * 姓名脱敏
         */
        NAME,
        /**
         * 地址脱敏
         */
        ADDRESS
    }
}