/*
 * Decompiled with CFR 0.152.
 */
package cn.com.anysdk.core.util;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.Set;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import org.apache.commons.collections4.MapUtils;

public class CollectionUtils {
    private CollectionUtils() {
        throw new IllegalStateException("Utility class");
    }

    public static boolean isEmpty(Collection<?> collection) {
        return org.apache.commons.collections4.CollectionUtils.isEmpty(collection);
    }

    public static boolean isNotEmpty(Collection<?> collection) {
        return org.apache.commons.collections4.CollectionUtils.isNotEmpty(collection);
    }

    public static boolean isEmpty(Map<?, ?> map) {
        return MapUtils.isEmpty(map);
    }

    public static boolean isNotEmpty(Map<?, ?> map) {
        return MapUtils.isNotEmpty(map);
    }

    public static int size(Collection<?> collection) {
        return collection != null ? collection.size() : 0;
    }

    public static int size(Map<?, ?> map) {
        return map != null ? map.size() : 0;
    }

    public static boolean contains(Collection<?> collection, Object element) {
        return collection != null && collection.contains(element);
    }

    public static boolean containsAll(Collection<?> collection, Collection<?> elements) {
        return org.apache.commons.collections4.CollectionUtils.containsAll(collection, elements);
    }

    public static boolean containsAny(Collection<?> collection, Collection<?> elements) {
        return org.apache.commons.collections4.CollectionUtils.containsAny(collection, elements);
    }

    public static <T> Collection<T> intersection(Collection<T> a, Collection<T> b) {
        return org.apache.commons.collections4.CollectionUtils.intersection(a, b);
    }

    public static <T> Collection<T> union(Collection<T> a, Collection<T> b) {
        return org.apache.commons.collections4.CollectionUtils.union(a, b);
    }

    public static <T> Collection<T> subtract(Collection<T> a, Collection<T> b) {
        return org.apache.commons.collections4.CollectionUtils.subtract(a, b);
    }

    public static <T> List<T> toList(Collection<T> collection) {
        return collection != null ? new ArrayList<T>(collection) : new ArrayList();
    }

    public static <T> Set<T> toSet(Collection<T> collection) {
        return collection != null ? new HashSet<T>(collection) : new HashSet();
    }

    public static <T, K, V> Map<K, V> toMap(Collection<T> collection, Function<T, K> keyMapper, Function<T, V> valueMapper) {
        return collection != null ? collection.stream().collect(Collectors.toMap(keyMapper, valueMapper)) : new HashMap();
    }

    public static <T, K> Map<K, T> toMap(Collection<T> collection, Function<T, K> keyMapper) {
        return CollectionUtils.toMap(collection, keyMapper, Function.identity());
    }

    public static <T, K> Map<K, List<T>> groupBy(Collection<T> collection, Function<T, K> classifier) {
        return collection != null ? collection.stream().collect(Collectors.groupingBy(classifier)) : new HashMap();
    }

    public static <T, K, V> Map<K, List<V>> groupBy(Collection<T> collection, Function<T, K> classifier, Function<T, V> valueMapper) {
        return collection != null ? collection.stream().collect(Collectors.groupingBy(classifier, Collectors.mapping(valueMapper, Collectors.toList()))) : new HashMap();
    }

    public static <T> List<T> filter(Collection<T> collection, Predicate<T> predicate) {
        return collection != null ? collection.stream().filter(predicate).collect(Collectors.toList()) : new ArrayList();
    }

    public static <T, R> List<R> map(Collection<T> collection, Function<T, R> mapper) {
        return collection != null ? collection.stream().map(mapper).collect(Collectors.toList()) : new ArrayList();
    }

    public static <T> T first(Collection<T> collection) {
        return CollectionUtils.isEmpty(collection) ? null : (T)collection.iterator().next();
    }

    public static <T> T last(Collection<T> collection) {
        if (CollectionUtils.isEmpty(collection)) {
            return null;
        }
        if (collection instanceof List) {
            List list = (List)collection;
            return (T)list.get(list.size() - 1);
        }
        T last = null;
        for (T element : collection) {
            last = element;
        }
        return last;
    }

    public static <T> T random(Collection<T> collection) {
        if (CollectionUtils.isEmpty(collection)) {
            return null;
        }
        int size = collection.size();
        int index = new Random().nextInt(size);
        if (collection instanceof List) {
            return (T)((List)collection).get(index);
        }
        int i = 0;
        for (T element : collection) {
            if (i == index) {
                return element;
            }
            ++i;
        }
        return null;
    }

    public static <T> List<T> random(Collection<T> collection, int count) {
        if (CollectionUtils.isEmpty(collection) || count <= 0) {
            return new ArrayList();
        }
        List<T> list = CollectionUtils.toList(collection);
        if (count >= list.size()) {
            return list;
        }
        Collections.shuffle(list);
        return list.subList(0, count);
    }
}

