/*
 * Decompiled with CFR 0.152.
 */
package cn.com.anysdk.core.util;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.core.TreeNode;
import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.JavaType;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.SerializationFeature;
import com.fasterxml.jackson.databind.node.ObjectNode;
import java.util.List;
import java.util.Map;

public class JsonUtils {
    private static final ObjectMapper OBJECT_MAPPER = new ObjectMapper();

    private JsonUtils() {
        throw new IllegalStateException("Utility class");
    }

    public static String toJson(Object obj) {
        try {
            return OBJECT_MAPPER.writeValueAsString(obj);
        }
        catch (JsonProcessingException e) {
            throw new RuntimeException("Convert object to JSON string failed", e);
        }
    }

    public static String toPrettyJson(Object obj) {
        try {
            return OBJECT_MAPPER.writerWithDefaultPrettyPrinter().writeValueAsString(obj);
        }
        catch (JsonProcessingException e) {
            throw new RuntimeException("Convert object to pretty JSON string failed", e);
        }
    }

    public static <T> T fromJson(String json, Class<T> clazz) {
        try {
            return (T)OBJECT_MAPPER.readValue(json, clazz);
        }
        catch (JsonProcessingException e) {
            throw new RuntimeException("Convert JSON string to object failed", e);
        }
    }

    public static <T> List<T> fromJsonList(String json, Class<T> elementClass) {
        try {
            return (List)OBJECT_MAPPER.readValue(json, (JavaType)OBJECT_MAPPER.getTypeFactory().constructCollectionType(List.class, elementClass));
        }
        catch (JsonProcessingException e) {
            throw new RuntimeException("Convert JSON string to list failed", e);
        }
    }

    public static Map<String, Object> fromJsonMap(String json) {
        try {
            return (Map)OBJECT_MAPPER.readValue(json, (TypeReference)new TypeReference<Map<String, Object>>(){});
        }
        catch (JsonProcessingException e) {
            throw new RuntimeException("Convert JSON string to map failed", e);
        }
    }

    public static JsonNode parseJson(String json) {
        try {
            return OBJECT_MAPPER.readTree(json);
        }
        catch (JsonProcessingException e) {
            throw new RuntimeException("Parse JSON string failed", e);
        }
    }

    public static ObjectNode createObjectNode() {
        return OBJECT_MAPPER.createObjectNode();
    }

    public static JsonNode toJsonNode(Object obj) {
        return OBJECT_MAPPER.valueToTree(obj);
    }

    public static <T> T fromJsonNode(JsonNode node, Class<T> clazz) {
        try {
            return (T)OBJECT_MAPPER.treeToValue((TreeNode)node, clazz);
        }
        catch (JsonProcessingException e) {
            throw new RuntimeException("Convert JsonNode to object failed", e);
        }
    }

    public static JsonNode merge(JsonNode source, JsonNode target) {
        if (!(source instanceof ObjectNode)) {
            return source;
        }
        if (!(target instanceof ObjectNode)) {
            return target;
        }
        ObjectNode result = ((ObjectNode)target).deepCopy();
        ((ObjectNode)source).fields().forEachRemaining(field -> result.set((String)field.getKey(), (JsonNode)field.getValue()));
        return result;
    }

    public static ObjectMapper getObjectMapper() {
        return OBJECT_MAPPER;
    }

    static {
        OBJECT_MAPPER.configure(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES, false);
        OBJECT_MAPPER.configure(SerializationFeature.WRITE_DATES_AS_TIMESTAMPS, false);
        OBJECT_MAPPER.configure(SerializationFeature.FAIL_ON_EMPTY_BEANS, false);
    }
}

