package cn.com.anysdk.core.annotation;

import java.lang.annotation.*;

/**
 * API 版本注解
 * 用于标记 API 的版本信息
 */
@Target({ElementType.TYPE, ElementType.METHOD})
@Retention(RetentionPolicy.RUNTIME)
@Documented
public @interface ApiVersion {
    /**
     * API 版本号
     */
    String value() default "1.0";

    /**
     * 是否废弃
     */
    boolean deprecated() default false;

    /**
     * 废弃说明
     */
    String deprecatedReason() default "";
}