/*
 * Decompiled with CFR 0.152.
 */
package cn.com.anysdk.core.util;

import java.io.File;
import java.io.IOException;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.attribute.PosixFilePermissions;
import java.nio.file.attribute.UserPrincipal;
import java.nio.file.attribute.UserPrincipalLookupService;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.commons.io.FilenameUtils;

public class FileUtils {
    private FileUtils() {
        throw new IllegalStateException("Utility class");
    }

    public static boolean exists(File file) {
        return file != null && file.exists();
    }

    public static boolean exists(String path) {
        return path != null && new File(path).exists();
    }

    public static boolean isDirectory(File file) {
        return file != null && file.isDirectory();
    }

    public static boolean isFile(File file) {
        return file != null && file.isFile();
    }

    public static long size(File file) {
        return file != null ? file.length() : 0L;
    }

    public static String getExtension(File file) {
        return file != null ? FilenameUtils.getExtension((String)file.getName()) : null;
    }

    public static String getBaseName(File file) {
        return file != null ? FilenameUtils.getBaseName((String)file.getName()) : null;
    }

    public static String getName(File file) {
        return file != null ? file.getName() : null;
    }

    public static String getPath(File file) {
        return file != null ? file.getPath() : null;
    }

    public static String getAbsolutePath(File file) {
        return file != null ? file.getAbsolutePath() : null;
    }

    public static String getCanonicalPath(File file) {
        try {
            return file != null ? file.getCanonicalPath() : null;
        }
        catch (IOException e) {
            return null;
        }
    }

    public static boolean mkdir(File dir) {
        return dir != null && dir.mkdir();
    }

    public static boolean mkdirs(File dir) {
        return dir != null && dir.mkdirs();
    }

    public static boolean createFile(File file) {
        try {
            return file != null && file.createNewFile();
        }
        catch (IOException e) {
            return false;
        }
    }

    public static boolean delete(File file) {
        return file != null && file.delete();
    }

    public static boolean deleteQuietly(File file) {
        return org.apache.commons.io.FileUtils.deleteQuietly((File)file);
    }

    public static boolean deleteDirectory(File dir) {
        try {
            org.apache.commons.io.FileUtils.deleteDirectory((File)dir);
            return true;
        }
        catch (IOException e) {
            return false;
        }
    }

    public static boolean copy(File src, File dest) {
        try {
            org.apache.commons.io.FileUtils.copyFile((File)src, (File)dest);
            return true;
        }
        catch (IOException e) {
            return false;
        }
    }

    public static boolean copyDirectory(File src, File dest) {
        try {
            org.apache.commons.io.FileUtils.copyDirectory((File)src, (File)dest);
            return true;
        }
        catch (IOException e) {
            return false;
        }
    }

    public static boolean move(File src, File dest) {
        try {
            org.apache.commons.io.FileUtils.moveFile((File)src, (File)dest);
            return true;
        }
        catch (IOException e) {
            return false;
        }
    }

    public static boolean moveDirectory(File src, File dest) {
        try {
            org.apache.commons.io.FileUtils.moveDirectory((File)src, (File)dest);
            return true;
        }
        catch (IOException e) {
            return false;
        }
    }

    public static String read(File file) {
        try {
            return org.apache.commons.io.FileUtils.readFileToString((File)file, (Charset)StandardCharsets.UTF_8);
        }
        catch (IOException e) {
            return null;
        }
    }

    public static String read(File file, Charset charset) {
        try {
            return org.apache.commons.io.FileUtils.readFileToString((File)file, (Charset)charset);
        }
        catch (IOException e) {
            return null;
        }
    }

    public static boolean write(File file, String content) {
        try {
            org.apache.commons.io.FileUtils.writeStringToFile((File)file, (String)content, (Charset)StandardCharsets.UTF_8);
            return true;
        }
        catch (IOException e) {
            return false;
        }
    }

    public static boolean write(File file, String content, Charset charset) {
        try {
            org.apache.commons.io.FileUtils.writeStringToFile((File)file, (String)content, (Charset)charset);
            return true;
        }
        catch (IOException e) {
            return false;
        }
    }

    public static boolean append(File file, String content) {
        try {
            org.apache.commons.io.FileUtils.writeStringToFile((File)file, (String)content, (Charset)StandardCharsets.UTF_8, (boolean)true);
            return true;
        }
        catch (IOException e) {
            return false;
        }
    }

    public static boolean append(File file, String content, Charset charset) {
        try {
            org.apache.commons.io.FileUtils.writeStringToFile((File)file, (String)content, (Charset)charset, (boolean)true);
            return true;
        }
        catch (IOException e) {
            return false;
        }
    }

    public static byte[] readBytes(File file) {
        try {
            return org.apache.commons.io.FileUtils.readFileToByteArray((File)file);
        }
        catch (IOException e) {
            return null;
        }
    }

    public static boolean writeBytes(File file, byte[] data) {
        try {
            org.apache.commons.io.FileUtils.writeByteArrayToFile((File)file, (byte[])data);
            return true;
        }
        catch (IOException e) {
            return false;
        }
    }

    public static List<File> listFiles(File dir) {
        if (dir == null || !dir.isDirectory()) {
            return new ArrayList<File>();
        }
        File[] files = dir.listFiles();
        return files != null ? List.of(files) : new ArrayList<File>();
    }

    public static List<File> listFilesRecursively(File dir) {
        if (dir == null || !dir.isDirectory()) {
            return new ArrayList<File>();
        }
        try {
            return Files.walk(dir.toPath(), new FileVisitOption[0]).map(Path::toFile).filter(File::isFile).collect(Collectors.toList());
        }
        catch (IOException e) {
            return new ArrayList<File>();
        }
    }

    public static List<File> listDirectories(File dir) {
        if (dir == null || !dir.isDirectory()) {
            return new ArrayList<File>();
        }
        File[] files = dir.listFiles();
        return files != null ? List.of(files).stream().filter(File::isDirectory).collect(Collectors.toList()) : new ArrayList<File>();
    }

    public static List<File> listDirectoriesRecursively(File dir) {
        if (dir == null || !dir.isDirectory()) {
            return new ArrayList<File>();
        }
        try {
            return Files.walk(dir.toPath(), new FileVisitOption[0]).map(Path::toFile).filter(File::isDirectory).collect(Collectors.toList());
        }
        catch (IOException e) {
            return new ArrayList<File>();
        }
    }

    public static long getDirectorySize(File dir) {
        if (dir == null || !dir.isDirectory()) {
            return 0L;
        }
        try {
            return Files.walk(dir.toPath(), new FileVisitOption[0]).map(Path::toFile).filter(File::isFile).mapToLong(File::length).sum();
        }
        catch (IOException e) {
            return 0L;
        }
    }

    public static long getLastModified(File file) {
        return file != null ? file.lastModified() : 0L;
    }

    public static boolean setLastModified(File file, long time) {
        return file != null && file.setLastModified(time);
    }

    public static String getPermissions(File file) {
        if (file == null) {
            return null;
        }
        try {
            return Files.getPosixFilePermissions(file.toPath(), new LinkOption[0]).toString();
        }
        catch (IOException e) {
            return null;
        }
    }

    public static boolean setPermissions(File file, String permissions) {
        if (file == null || permissions == null) {
            return false;
        }
        try {
            Files.setPosixFilePermissions(file.toPath(), PosixFilePermissions.fromString(permissions));
            return true;
        }
        catch (IOException e) {
            return false;
        }
    }

    public static String getOwner(File file) {
        if (file == null) {
            return null;
        }
        try {
            return Files.getOwner(file.toPath(), new LinkOption[0]).getName();
        }
        catch (IOException e) {
            return null;
        }
    }

    public static boolean setOwner(File file, String owner) {
        if (file == null || owner == null) {
            return false;
        }
        try {
            UserPrincipalLookupService lookupService = file.toPath().getFileSystem().getUserPrincipalLookupService();
            UserPrincipal userPrincipal = lookupService.lookupPrincipalByName(owner);
            Files.setOwner(file.toPath(), userPrincipal);
            return true;
        }
        catch (IOException e) {
            return false;
        }
    }

    public static String getGroup(File file) {
        if (file == null) {
            return null;
        }
        try {
            return Files.getAttribute(file.toPath(), "group", new LinkOption[0]).toString();
        }
        catch (IOException e) {
            return null;
        }
    }

    public static boolean setGroup(File file, String group) {
        if (file == null || group == null) {
            return false;
        }
        try {
            Files.setAttribute(file.toPath(), "group", group, new LinkOption[0]);
            return true;
        }
        catch (IOException e) {
            return false;
        }
    }
}

