/*
 * Decompiled with CFR 0.152.
 */
package cn.com.anysdk.core.util;

import java.io.IOException;
import java.io.InputStream;
import java.net.HttpURLConnection;
import java.net.URL;
import java.nio.charset.StandardCharsets;
import java.util.Map;
import java.util.StringJoiner;

public class HttpUtils {
    private static final int CONNECT_TIMEOUT = 5000;
    private static final int READ_TIMEOUT = 10000;
    private static final String USER_AGENT = "AnySDK/1.0";

    private HttpUtils() {
        throw new IllegalStateException("Utility class");
    }

    public static String get(String url) {
        return HttpUtils.get(url, null);
    }

    public static String get(String url, Map<String, String> headers) {
        try {
            HttpURLConnection conn = HttpUtils.createConnection(url, "GET");
            if (headers != null) {
                headers.forEach(conn::setRequestProperty);
            }
            return HttpUtils.handleResponse(conn);
        }
        catch (IOException e) {
            throw new RuntimeException("HTTP GET request failed: " + e.getMessage(), e);
        }
    }

    public static String post(String url, String body) {
        return HttpUtils.post(url, body, null);
    }

    public static String post(String url, String body, Map<String, String> headers) {
        try {
            HttpURLConnection conn = HttpUtils.createConnection(url, "POST");
            conn.setDoOutput(true);
            if (headers != null) {
                headers.forEach(conn::setRequestProperty);
            }
            if (body != null) {
                conn.getOutputStream().write(body.getBytes(StandardCharsets.UTF_8));
            }
            return HttpUtils.handleResponse(conn);
        }
        catch (IOException e) {
            throw new RuntimeException("HTTP POST request failed: " + e.getMessage(), e);
        }
    }

    public static String put(String url, String body) {
        return HttpUtils.put(url, body, null);
    }

    public static String put(String url, String body, Map<String, String> headers) {
        try {
            HttpURLConnection conn = HttpUtils.createConnection(url, "PUT");
            conn.setDoOutput(true);
            if (headers != null) {
                headers.forEach(conn::setRequestProperty);
            }
            if (body != null) {
                conn.getOutputStream().write(body.getBytes(StandardCharsets.UTF_8));
            }
            return HttpUtils.handleResponse(conn);
        }
        catch (IOException e) {
            throw new RuntimeException("HTTP PUT request failed: " + e.getMessage(), e);
        }
    }

    public static String delete(String url) {
        return HttpUtils.delete(url, null);
    }

    public static String delete(String url, Map<String, String> headers) {
        try {
            HttpURLConnection conn = HttpUtils.createConnection(url, "DELETE");
            if (headers != null) {
                headers.forEach(conn::setRequestProperty);
            }
            return HttpUtils.handleResponse(conn);
        }
        catch (IOException e) {
            throw new RuntimeException("HTTP DELETE request failed: " + e.getMessage(), e);
        }
    }

    public static String buildUrlParams(Map<String, String> params) {
        if (params == null || params.isEmpty()) {
            return "";
        }
        StringJoiner joiner = new StringJoiner("&");
        params.forEach((key, value) -> joiner.add(key + "=" + value));
        return joiner.toString();
    }

    private static HttpURLConnection createConnection(String url, String method) throws IOException {
        HttpURLConnection conn = (HttpURLConnection)new URL(url).openConnection();
        conn.setRequestMethod(method);
        conn.setConnectTimeout(5000);
        conn.setReadTimeout(10000);
        conn.setRequestProperty("User-Agent", USER_AGENT);
        conn.setRequestProperty("Accept", "application/json");
        conn.setRequestProperty("Content-Type", "application/json");
        return conn;
    }

    private static String handleResponse(HttpURLConnection conn) throws IOException {
        try {
            int responseCode = conn.getResponseCode();
            if (responseCode >= 200 && responseCode < 300) {
                String string = HttpUtils.readInputStream(conn.getInputStream());
                return string;
            }
            String errorMessage = HttpUtils.readInputStream(conn.getErrorStream());
            throw new IOException("HTTP request failed with response code " + responseCode + ": " + errorMessage);
        }
        finally {
            conn.disconnect();
        }
    }

    private static String readInputStream(InputStream inputStream) throws IOException {
        int bytesRead;
        if (inputStream == null) {
            return "";
        }
        byte[] buffer = new byte[1024];
        StringBuilder response = new StringBuilder();
        while ((bytesRead = inputStream.read(buffer)) != -1) {
            response.append(new String(buffer, 0, bytesRead, StandardCharsets.UTF_8));
        }
        return response.toString();
    }
}

