/*
 * Decompiled with CFR 0.152.
 */
package cn.com.anysdk.core.util;

import java.util.Collection;
import java.util.Map;
import java.util.regex.Pattern;

public class ValidationUtils {
    private static final Pattern EMAIL_PATTERN = Pattern.compile("^[A-Za-z0-9+_.-]+@[A-Za-z0-9.-]+$");
    private static final Pattern PHONE_PATTERN = Pattern.compile("^1[3-9]\\d{9}$");
    private static final Pattern ID_CARD_PATTERN = Pattern.compile("^[1-9]\\d{5}(19|20)\\d{2}(0[1-9]|1[0-2])(0[1-9]|[12]\\d|3[01])\\d{3}[0-9Xx]$");
    private static final Pattern URL_PATTERN = Pattern.compile("^(https?|ftp)://[^\\s/$.?#].[^\\s]*$");
    private static final Pattern IPV4_PATTERN = Pattern.compile("^((25[0-5]|2[0-4]\\d|[01]?\\d\\d?)\\.){3}(25[0-5]|2[0-4]\\d|[01]?\\d\\d?)$");
    private static final Pattern IPV6_PATTERN = Pattern.compile("^([0-9a-fA-F]{1,4}:){7}[0-9a-fA-F]{1,4}$");

    private ValidationUtils() {
        throw new IllegalStateException("Utility class");
    }

    public static boolean isNull(Object obj) {
        return obj == null;
    }

    public static boolean isNotNull(Object obj) {
        return obj != null;
    }

    public static boolean isEmpty(String str) {
        return str == null || str.isEmpty();
    }

    public static boolean isNotEmpty(String str) {
        return !ValidationUtils.isEmpty(str);
    }

    public static boolean isEmpty(Collection<?> collection) {
        return collection == null || collection.isEmpty();
    }

    public static boolean isNotEmpty(Collection<?> collection) {
        return !ValidationUtils.isEmpty(collection);
    }

    public static boolean isEmpty(Map<?, ?> map) {
        return map == null || map.isEmpty();
    }

    public static boolean isNotEmpty(Map<?, ?> map) {
        return !ValidationUtils.isEmpty(map);
    }

    public static boolean isEmpty(Object[] array) {
        return array == null || array.length == 0;
    }

    public static boolean isNotEmpty(Object[] array) {
        return !ValidationUtils.isEmpty(array);
    }

    public static boolean isNumeric(String str) {
        if (ValidationUtils.isEmpty(str)) {
            return false;
        }
        for (char c : str.toCharArray()) {
            if (Character.isDigit(c)) continue;
            return false;
        }
        return true;
    }

    public static boolean isEmail(String email) {
        return ValidationUtils.isNotEmpty(email) && EMAIL_PATTERN.matcher(email).matches();
    }

    public static boolean isPhone(String phone) {
        return ValidationUtils.isNotEmpty(phone) && PHONE_PATTERN.matcher(phone).matches();
    }

    public static boolean isIdCard(String idCard) {
        return ValidationUtils.isNotEmpty(idCard) && ID_CARD_PATTERN.matcher(idCard).matches();
    }

    public static boolean isUrl(String url) {
        return ValidationUtils.isNotEmpty(url) && URL_PATTERN.matcher(url).matches();
    }

    public static boolean isIpv4(String ipv4) {
        return ValidationUtils.isNotEmpty(ipv4) && IPV4_PATTERN.matcher(ipv4).matches();
    }

    public static boolean isIpv6(String ipv6) {
        return ValidationUtils.isNotEmpty(ipv6) && IPV6_PATTERN.matcher(ipv6).matches();
    }

    public static boolean isLengthBetween(String str, int minLength, int maxLength) {
        if (ValidationUtils.isEmpty(str)) {
            return false;
        }
        int length = str.length();
        return length >= minLength && length <= maxLength;
    }

    public static boolean isNumberBetween(int number, int min, int max) {
        return number >= min && number <= max;
    }

    public static boolean isNumberBetween(long number, long min, long max) {
        return number >= min && number <= max;
    }

    public static boolean isNumberBetween(double number, double min, double max) {
        return number >= min && number <= max;
    }
}

