package cn.com.anysdk.map.config;

import cn.com.anysdk.map.model.MapProviderType;
import lombok.Data;
import org.apache.hc.core5.util.Timeout;

/**
 * 百度地图配置
 */
@Data
public class BaiduMapConfig implements MapConfig {
    /**
     * 是否启用
     */
    private boolean enabled = true;

    /**
     * API Key
     */
    private String ak;

    /**
     * 安全密钥
     */
    private String sk;

    /**
     * 请求超时时间（毫秒）
     */
    private Timeout timeout = Timeout.ofDays(5000);

    /**
     * 重试次数
     */
    private int retryTimes = 3;

    /**
     * 重试间隔（毫秒）
     */
    private int retryInterval = 1000;

    /**
     * 地图服务商类型
     */
    private MapProviderType type = MapProviderType.BAIDU;

    /**
     * 默认坐标系类型
     */
    private String defaultCoordinateType = "BD09";

    /**
     * 是否启用缓存
     */
    private boolean cacheEnabled = true;

    /**
     * 缓存过期时间（秒）
     */
    private int cacheExpireSeconds = 3600;

    /**
     * 是否启用日志
     */
    private boolean logEnabled = true;

    /**
     * 日志级别
     */
    private String logLevel = "INFO";

    @Override
    public boolean isEnabled() {
        return enabled;
    }

    @Override
    public String getAk() {
        return ak;
    }

    @Override
    public String getSk() {
        return sk;
    }

    @Override
    public Timeout getTimeout() {
        return timeout;
    }

    @Override
    public int getRetryTimes() {
        return retryTimes;
    }

    @Override
    public int getRetryInterval() {
        return retryInterval;
    }

    @Override
    public MapProviderType getType() {
        return type;
    }

    @Override
    public String getDefaultCoordinateType() {
        return defaultCoordinateType;
    }

    @Override
    public boolean isCacheEnabled() {
        return cacheEnabled;
    }

    @Override
    public int getCacheExpireSeconds() {
        return cacheExpireSeconds;
    }

    @Override
    public boolean isLogEnabled() {
        return logEnabled;
    }

    @Override
    public String getLogLevel() {
        return logLevel;
    }
}