package cn.com.anysdk.map.config;

import cn.com.anysdk.map.model.MapProviderType;
import org.apache.hc.core5.util.Timeout;

/**
 * 通用地图配置接口
 */
public interface MapConfig {
    /**
     * 是否启用
     */
    boolean isEnabled();

    /**
     * API Key
     */
    String getAk();

    /**
     * 安全密钥
     */
    String getSk();

    /**
     * 请求超时时间（毫秒）
     */
    Timeout getTimeout();

    /**
     * 重试次数
     */
    int getRetryTimes();

    /**
     * 重试间隔（毫秒）
     */
    int getRetryInterval();

    /**
     * 地图服务商类型
     */
    MapProviderType getType();

    /**
     * 默认坐标系类型
     */
    String getDefaultCoordinateType();

    /**
     * 是否启用缓存
     */
    boolean isCacheEnabled();

    /**
     * 缓存过期时间（秒）
     */
    int getCacheExpireSeconds();

    /**
     * 是否启用日志
     */
    boolean isLogEnabled();

    /**
     * 日志级别
     */
    String getLogLevel();
} 