package cn.com.anysdk.map.exception;

/**
 * 地图服务基础异常类
 */
public class MapException extends RuntimeException {
    
    private final String code;
    
    public MapException(String message) {
        super(message);
        this.code = "MAP_ERROR";
    }
    
    public MapException(String code, String message) {
        super(message);
        this.code = code;
    }
    
    public MapException(String message, Throwable cause) {
        super(message, cause);
        this.code = "MAP_ERROR";
    }
    
    public MapException(String code, String message, Throwable cause) {
        super(message, cause);
        this.code = code;
    }
    
    public String getCode() {
        return code;
    }
}
