package cn.com.anysdk.map.model;

import lombok.Data;
import lombok.Builder;

/**
 * 地址信息结果
 */
@Data
@Builder
public class AddressResult {
    /**
     * 完整地址
     */
    private String formattedAddress;

    /**
     * 省份
     */
    private String province;

    /**
     * 城市
     */
    private String city;

    /**
     * 区县
     */
    private String district;

    /**
     * 街道
     */
    private String street;

    /**
     * 门牌号
     */
    private String streetNumber;

    /**
     * 位置信息
     */
    private Location location;

    /**
     * 兴趣点名称
     */
    private String poiName;

    /**
     * 兴趣点类型
     */
    private String poiType;

    /**
     * 兴趣点地址
     */
    private String poiAddress;

    /**
     * 是否成功
     */
    private boolean success;

    /**
     * 错误信息
     */
    private String errorMessage;

    /**
     * 创建成功结果
     */
    public static AddressResult success(String formattedAddress, Location location) {
        return AddressResult.builder()
                .formattedAddress(formattedAddress)
                .location(location)
                .success(true)
                .build();
    }

    /**
     * 创建失败结果
     */
    public static AddressResult error(String errorMessage) {
        return AddressResult.builder()
                .success(false)
                .errorMessage(errorMessage)
                .build();
    }
} 