package cn.com.anysdk.map.model;

import lombok.Data;
import lombok.Builder;

/**
 * 位置信息结果
 */
@Data
@Builder
public class LocationResult {
    /**
     * 位置信息
     */
    private Location location;

    /**
     * 地址信息
     */
    private String address;

    /**
     * 省份
     */
    private String province;

    /**
     * 城市
     */
    private String city;

    /**
     * 区县
     */
    private String district;

    /**
     * 街道
     */
    private String street;

    /**
     * 门牌号
     */
    private String streetNumber;

    /**
     * 是否成功
     */
    private boolean success;

    /**
     * 错误信息
     */
    private String errorMessage;

    /**
     * 创建成功结果
     */
    public static LocationResult success(Location location, String address) {
        return LocationResult.builder()
                .location(location)
                .address(address)
                .success(true)
                .build();
    }

    /**
     * 创建失败结果
     */
    public static LocationResult error(String errorMessage) {
        return LocationResult.builder()
                .success(false)
                .errorMessage(errorMessage)
                .build();
    }
} 