package cn.com.anysdk.map.service;

import cn.com.anysdk.map.model.*;

/**
 * 地图服务接口
 * 支持百度地图、高德地图、腾讯地图等多种地图服务商
 */
public interface MapService {
    
    /**
     * 地址解析（地址转坐标）
     *
     * @param address 地址
     * @return 坐标信息
     */
    LocationResult geocode(String address);

    /**
     * 逆地址解析（坐标转地址）
     *
     * @param location 坐标信息
     * @return 地址信息
     */
    AddressResult reverseGeocode(Location location);

    /**
     * 坐标转换（不同坐标系之间的转换）
     *
     * @param location 原始坐标
     * @param fromType 原始坐标系类型
     * @param toType 目标坐标系类型
     * @return 转换后的坐标
     */
    LocationResult convertCoordinate(Location location, CoordinateType fromType, CoordinateType toType);


    /**
     * 获取地图服务商类型
     *
     * @return 地图服务商类型
     */
    MapProviderType getProviderType();

    /**
     * 获取静态地图URL
     *
     * @param address 地址
     * @param zoom 缩放级别（1-18）
     * @return 静态地图URL
     */
    default String getStaticMapUrl(String address, int zoom) {
        throw new UnsupportedOperationException("getStaticMapUrl not implemented for this provider");
    };
} 