package cn.com.anysdk.map.service;

import cn.com.anysdk.map.model.*;

public class MockService implements MapService {
    
    // 模拟的默认坐标（北京市天安门）
    private static final double MOCK_LATITUDE = 39.908823;
    private static final double MOCK_LONGITUDE = 116.397470;
    
    // 模拟的默认地址
    private static final String MOCK_ADDRESS = "北京市东城区天安门广场";
    
    @Override
    public LocationResult geocode(String address) {
        // 模拟地址解析，返回固定坐标
        Location location = new Location();
        location.setLatitude(MOCK_LATITUDE);
        location.setLongitude(MOCK_LONGITUDE);
        location.setCoordinateType(CoordinateType.GCJ02);
        
        return LocationResult.success(location, address);
    }

    @Override
    public AddressResult reverseGeocode(Location location) {
        // 模拟逆地址解析，返回固定地址
        return AddressResult.success(MOCK_ADDRESS, location);
    }

    @Override
    public LocationResult convertCoordinate(Location location, CoordinateType fromType, CoordinateType toType) {
        // 模拟坐标转换，直接返回原始坐标
        Location convertedLocation = new Location();
        convertedLocation.setLatitude(location.getLatitude());
        convertedLocation.setLongitude(location.getLongitude());
        convertedLocation.setCoordinateType(toType);
        
        return LocationResult.success(convertedLocation, null);
    }

    @Override
    public MapProviderType getProviderType() {
        // 返回模拟服务类型
        return MapProviderType.MOCK;
    }
}
