/*
 * Decompiled with CFR 0.152.
 */
package cn.com.anysdk.map.factory;

import cn.com.anysdk.map.config.AmapConfig;
import cn.com.anysdk.map.config.BaiduMapConfig;
import cn.com.anysdk.map.config.MapConfig;
import cn.com.anysdk.map.exception.MapConfigException;
import cn.com.anysdk.map.model.MapProviderType;
import cn.com.anysdk.map.service.AmapService;
import cn.com.anysdk.map.service.BaiduMapService;
import cn.com.anysdk.map.service.MapService;
import cn.com.anysdk.map.service.MockService;
import org.apache.hc.client5.http.config.RequestConfig;
import org.apache.hc.client5.http.impl.classic.CloseableHttpClient;
import org.apache.hc.client5.http.impl.classic.HttpClients;
import org.apache.hc.client5.http.impl.io.PoolingHttpClientConnectionManager;
import org.apache.hc.client5.http.io.HttpClientConnectionManager;

public class MapServiceFactory {
    public static MapService createMapService(MapConfig config) {
        if (config == null) {
            throw new MapConfigException("MapConfig cannot be null");
        }
        if (!config.isEnabled()) {
            throw new MapConfigException("Map service is disabled");
        }
        return switch (config.getType()) {
            case MapProviderType.BAIDU -> {
                if (!(config instanceof BaiduMapConfig)) {
                    throw new MapConfigException("Invalid config type for Baidu Map");
                }
                CloseableHttpClient httpClient = MapServiceFactory.createHttpClient(config);
                yield new BaiduMapService((BaiduMapConfig)config, httpClient);
            }
            case MapProviderType.AMAP -> {
                if (!(config instanceof AmapConfig)) {
                    throw new MapConfigException("Invalid config type for Amap");
                }
                CloseableHttpClient httpClient = MapServiceFactory.createHttpClient(config);
                yield new AmapService((AmapConfig)config, httpClient);
            }
            case MapProviderType.MOCK -> new MockService();
            default -> throw new MapConfigException("Unsupported map provider type: " + String.valueOf((Object)config.getType()));
        };
    }

    private static CloseableHttpClient createHttpClient(MapConfig config) {
        PoolingHttpClientConnectionManager connectionManager = new PoolingHttpClientConnectionManager();
        connectionManager.setMaxTotal(100);
        connectionManager.setDefaultMaxPerRoute(20);
        return HttpClients.custom().setConnectionManager((HttpClientConnectionManager)connectionManager).setDefaultRequestConfig(RequestConfig.custom().setResponseTimeout(config.getTimeout()).build()).build();
    }
}

