/*
 * Decompiled with CFR 0.152.
 */
package cn.com.anysdk.map.model;

import cn.com.anysdk.map.model.Location;

public class AddressResult {
    private String formattedAddress;
    private String province;
    private String city;
    private String district;
    private String street;
    private String streetNumber;
    private Location location;
    private String poiName;
    private String poiType;
    private String poiAddress;
    private boolean success;
    private String errorMessage;

    public static AddressResult success(String formattedAddress, Location location) {
        return AddressResult.builder().formattedAddress(formattedAddress).location(location).success(true).build();
    }

    public static AddressResult error(String errorMessage) {
        return AddressResult.builder().success(false).errorMessage(errorMessage).build();
    }

    AddressResult(String formattedAddress, String province, String city, String district, String street, String streetNumber, Location location, String poiName, String poiType, String poiAddress, boolean success, String errorMessage) {
        this.formattedAddress = formattedAddress;
        this.province = province;
        this.city = city;
        this.district = district;
        this.street = street;
        this.streetNumber = streetNumber;
        this.location = location;
        this.poiName = poiName;
        this.poiType = poiType;
        this.poiAddress = poiAddress;
        this.success = success;
        this.errorMessage = errorMessage;
    }

    public static AddressResultBuilder builder() {
        return new AddressResultBuilder();
    }

    public String getFormattedAddress() {
        return this.formattedAddress;
    }

    public String getProvince() {
        return this.province;
    }

    public String getCity() {
        return this.city;
    }

    public String getDistrict() {
        return this.district;
    }

    public String getStreet() {
        return this.street;
    }

    public String getStreetNumber() {
        return this.streetNumber;
    }

    public Location getLocation() {
        return this.location;
    }

    public String getPoiName() {
        return this.poiName;
    }

    public String getPoiType() {
        return this.poiType;
    }

    public String getPoiAddress() {
        return this.poiAddress;
    }

    public boolean isSuccess() {
        return this.success;
    }

    public String getErrorMessage() {
        return this.errorMessage;
    }

    public void setFormattedAddress(String formattedAddress) {
        this.formattedAddress = formattedAddress;
    }

    public void setProvince(String province) {
        this.province = province;
    }

    public void setCity(String city) {
        this.city = city;
    }

    public void setDistrict(String district) {
        this.district = district;
    }

    public void setStreet(String street) {
        this.street = street;
    }

    public void setStreetNumber(String streetNumber) {
        this.streetNumber = streetNumber;
    }

    public void setLocation(Location location) {
        this.location = location;
    }

    public void setPoiName(String poiName) {
        this.poiName = poiName;
    }

    public void setPoiType(String poiType) {
        this.poiType = poiType;
    }

    public void setPoiAddress(String poiAddress) {
        this.poiAddress = poiAddress;
    }

    public void setSuccess(boolean success) {
        this.success = success;
    }

    public void setErrorMessage(String errorMessage) {
        this.errorMessage = errorMessage;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof AddressResult)) {
            return false;
        }
        AddressResult other = (AddressResult)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.isSuccess() != other.isSuccess()) {
            return false;
        }
        String this$formattedAddress = this.getFormattedAddress();
        String other$formattedAddress = other.getFormattedAddress();
        if (this$formattedAddress == null ? other$formattedAddress != null : !this$formattedAddress.equals(other$formattedAddress)) {
            return false;
        }
        String this$province = this.getProvince();
        String other$province = other.getProvince();
        if (this$province == null ? other$province != null : !this$province.equals(other$province)) {
            return false;
        }
        String this$city = this.getCity();
        String other$city = other.getCity();
        if (this$city == null ? other$city != null : !this$city.equals(other$city)) {
            return false;
        }
        String this$district = this.getDistrict();
        String other$district = other.getDistrict();
        if (this$district == null ? other$district != null : !this$district.equals(other$district)) {
            return false;
        }
        String this$street = this.getStreet();
        String other$street = other.getStreet();
        if (this$street == null ? other$street != null : !this$street.equals(other$street)) {
            return false;
        }
        String this$streetNumber = this.getStreetNumber();
        String other$streetNumber = other.getStreetNumber();
        if (this$streetNumber == null ? other$streetNumber != null : !this$streetNumber.equals(other$streetNumber)) {
            return false;
        }
        Location this$location = this.getLocation();
        Location other$location = other.getLocation();
        if (this$location == null ? other$location != null : !((Object)this$location).equals(other$location)) {
            return false;
        }
        String this$poiName = this.getPoiName();
        String other$poiName = other.getPoiName();
        if (this$poiName == null ? other$poiName != null : !this$poiName.equals(other$poiName)) {
            return false;
        }
        String this$poiType = this.getPoiType();
        String other$poiType = other.getPoiType();
        if (this$poiType == null ? other$poiType != null : !this$poiType.equals(other$poiType)) {
            return false;
        }
        String this$poiAddress = this.getPoiAddress();
        String other$poiAddress = other.getPoiAddress();
        if (this$poiAddress == null ? other$poiAddress != null : !this$poiAddress.equals(other$poiAddress)) {
            return false;
        }
        String this$errorMessage = this.getErrorMessage();
        String other$errorMessage = other.getErrorMessage();
        return !(this$errorMessage == null ? other$errorMessage != null : !this$errorMessage.equals(other$errorMessage));
    }

    protected boolean canEqual(Object other) {
        return other instanceof AddressResult;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + (this.isSuccess() ? 79 : 97);
        String $formattedAddress = this.getFormattedAddress();
        result = result * 59 + ($formattedAddress == null ? 43 : $formattedAddress.hashCode());
        String $province = this.getProvince();
        result = result * 59 + ($province == null ? 43 : $province.hashCode());
        String $city = this.getCity();
        result = result * 59 + ($city == null ? 43 : $city.hashCode());
        String $district = this.getDistrict();
        result = result * 59 + ($district == null ? 43 : $district.hashCode());
        String $street = this.getStreet();
        result = result * 59 + ($street == null ? 43 : $street.hashCode());
        String $streetNumber = this.getStreetNumber();
        result = result * 59 + ($streetNumber == null ? 43 : $streetNumber.hashCode());
        Location $location = this.getLocation();
        result = result * 59 + ($location == null ? 43 : ((Object)$location).hashCode());
        String $poiName = this.getPoiName();
        result = result * 59 + ($poiName == null ? 43 : $poiName.hashCode());
        String $poiType = this.getPoiType();
        result = result * 59 + ($poiType == null ? 43 : $poiType.hashCode());
        String $poiAddress = this.getPoiAddress();
        result = result * 59 + ($poiAddress == null ? 43 : $poiAddress.hashCode());
        String $errorMessage = this.getErrorMessage();
        result = result * 59 + ($errorMessage == null ? 43 : $errorMessage.hashCode());
        return result;
    }

    public String toString() {
        return "AddressResult(formattedAddress=" + this.getFormattedAddress() + ", province=" + this.getProvince() + ", city=" + this.getCity() + ", district=" + this.getDistrict() + ", street=" + this.getStreet() + ", streetNumber=" + this.getStreetNumber() + ", location=" + String.valueOf(this.getLocation()) + ", poiName=" + this.getPoiName() + ", poiType=" + this.getPoiType() + ", poiAddress=" + this.getPoiAddress() + ", success=" + this.isSuccess() + ", errorMessage=" + this.getErrorMessage() + ")";
    }

    public static class AddressResultBuilder {
        private String formattedAddress;
        private String province;
        private String city;
        private String district;
        private String street;
        private String streetNumber;
        private Location location;
        private String poiName;
        private String poiType;
        private String poiAddress;
        private boolean success;
        private String errorMessage;

        AddressResultBuilder() {
        }

        public AddressResultBuilder formattedAddress(String formattedAddress) {
            this.formattedAddress = formattedAddress;
            return this;
        }

        public AddressResultBuilder province(String province) {
            this.province = province;
            return this;
        }

        public AddressResultBuilder city(String city) {
            this.city = city;
            return this;
        }

        public AddressResultBuilder district(String district) {
            this.district = district;
            return this;
        }

        public AddressResultBuilder street(String street) {
            this.street = street;
            return this;
        }

        public AddressResultBuilder streetNumber(String streetNumber) {
            this.streetNumber = streetNumber;
            return this;
        }

        public AddressResultBuilder location(Location location) {
            this.location = location;
            return this;
        }

        public AddressResultBuilder poiName(String poiName) {
            this.poiName = poiName;
            return this;
        }

        public AddressResultBuilder poiType(String poiType) {
            this.poiType = poiType;
            return this;
        }

        public AddressResultBuilder poiAddress(String poiAddress) {
            this.poiAddress = poiAddress;
            return this;
        }

        public AddressResultBuilder success(boolean success) {
            this.success = success;
            return this;
        }

        public AddressResultBuilder errorMessage(String errorMessage) {
            this.errorMessage = errorMessage;
            return this;
        }

        public AddressResult build() {
            return new AddressResult(this.formattedAddress, this.province, this.city, this.district, this.street, this.streetNumber, this.location, this.poiName, this.poiType, this.poiAddress, this.success, this.errorMessage);
        }

        public String toString() {
            return "AddressResult.AddressResultBuilder(formattedAddress=" + this.formattedAddress + ", province=" + this.province + ", city=" + this.city + ", district=" + this.district + ", street=" + this.street + ", streetNumber=" + this.streetNumber + ", location=" + String.valueOf(this.location) + ", poiName=" + this.poiName + ", poiType=" + this.poiType + ", poiAddress=" + this.poiAddress + ", success=" + this.success + ", errorMessage=" + this.errorMessage + ")";
        }
    }
}

