/*
 * Decompiled with CFR 0.152.
 */
package cn.com.anysdk.map.model;

import cn.com.anysdk.map.model.Location;

public class LocationResult {
    private Location location;
    private String address;
    private String province;
    private String city;
    private String district;
    private String street;
    private String streetNumber;
    private boolean success;
    private String errorMessage;

    public static LocationResult success(Location location, String address) {
        return LocationResult.builder().location(location).address(address).success(true).build();
    }

    public static LocationResult error(String errorMessage) {
        return LocationResult.builder().success(false).errorMessage(errorMessage).build();
    }

    LocationResult(Location location, String address, String province, String city, String district, String street, String streetNumber, boolean success, String errorMessage) {
        this.location = location;
        this.address = address;
        this.province = province;
        this.city = city;
        this.district = district;
        this.street = street;
        this.streetNumber = streetNumber;
        this.success = success;
        this.errorMessage = errorMessage;
    }

    public static LocationResultBuilder builder() {
        return new LocationResultBuilder();
    }

    public Location getLocation() {
        return this.location;
    }

    public String getAddress() {
        return this.address;
    }

    public String getProvince() {
        return this.province;
    }

    public String getCity() {
        return this.city;
    }

    public String getDistrict() {
        return this.district;
    }

    public String getStreet() {
        return this.street;
    }

    public String getStreetNumber() {
        return this.streetNumber;
    }

    public boolean isSuccess() {
        return this.success;
    }

    public String getErrorMessage() {
        return this.errorMessage;
    }

    public void setLocation(Location location) {
        this.location = location;
    }

    public void setAddress(String address) {
        this.address = address;
    }

    public void setProvince(String province) {
        this.province = province;
    }

    public void setCity(String city) {
        this.city = city;
    }

    public void setDistrict(String district) {
        this.district = district;
    }

    public void setStreet(String street) {
        this.street = street;
    }

    public void setStreetNumber(String streetNumber) {
        this.streetNumber = streetNumber;
    }

    public void setSuccess(boolean success) {
        this.success = success;
    }

    public void setErrorMessage(String errorMessage) {
        this.errorMessage = errorMessage;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof LocationResult)) {
            return false;
        }
        LocationResult other = (LocationResult)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.isSuccess() != other.isSuccess()) {
            return false;
        }
        Location this$location = this.getLocation();
        Location other$location = other.getLocation();
        if (this$location == null ? other$location != null : !((Object)this$location).equals(other$location)) {
            return false;
        }
        String this$address = this.getAddress();
        String other$address = other.getAddress();
        if (this$address == null ? other$address != null : !this$address.equals(other$address)) {
            return false;
        }
        String this$province = this.getProvince();
        String other$province = other.getProvince();
        if (this$province == null ? other$province != null : !this$province.equals(other$province)) {
            return false;
        }
        String this$city = this.getCity();
        String other$city = other.getCity();
        if (this$city == null ? other$city != null : !this$city.equals(other$city)) {
            return false;
        }
        String this$district = this.getDistrict();
        String other$district = other.getDistrict();
        if (this$district == null ? other$district != null : !this$district.equals(other$district)) {
            return false;
        }
        String this$street = this.getStreet();
        String other$street = other.getStreet();
        if (this$street == null ? other$street != null : !this$street.equals(other$street)) {
            return false;
        }
        String this$streetNumber = this.getStreetNumber();
        String other$streetNumber = other.getStreetNumber();
        if (this$streetNumber == null ? other$streetNumber != null : !this$streetNumber.equals(other$streetNumber)) {
            return false;
        }
        String this$errorMessage = this.getErrorMessage();
        String other$errorMessage = other.getErrorMessage();
        return !(this$errorMessage == null ? other$errorMessage != null : !this$errorMessage.equals(other$errorMessage));
    }

    protected boolean canEqual(Object other) {
        return other instanceof LocationResult;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + (this.isSuccess() ? 79 : 97);
        Location $location = this.getLocation();
        result = result * 59 + ($location == null ? 43 : ((Object)$location).hashCode());
        String $address = this.getAddress();
        result = result * 59 + ($address == null ? 43 : $address.hashCode());
        String $province = this.getProvince();
        result = result * 59 + ($province == null ? 43 : $province.hashCode());
        String $city = this.getCity();
        result = result * 59 + ($city == null ? 43 : $city.hashCode());
        String $district = this.getDistrict();
        result = result * 59 + ($district == null ? 43 : $district.hashCode());
        String $street = this.getStreet();
        result = result * 59 + ($street == null ? 43 : $street.hashCode());
        String $streetNumber = this.getStreetNumber();
        result = result * 59 + ($streetNumber == null ? 43 : $streetNumber.hashCode());
        String $errorMessage = this.getErrorMessage();
        result = result * 59 + ($errorMessage == null ? 43 : $errorMessage.hashCode());
        return result;
    }

    public String toString() {
        return "LocationResult(location=" + String.valueOf(this.getLocation()) + ", address=" + this.getAddress() + ", province=" + this.getProvince() + ", city=" + this.getCity() + ", district=" + this.getDistrict() + ", street=" + this.getStreet() + ", streetNumber=" + this.getStreetNumber() + ", success=" + this.isSuccess() + ", errorMessage=" + this.getErrorMessage() + ")";
    }

    public static class LocationResultBuilder {
        private Location location;
        private String address;
        private String province;
        private String city;
        private String district;
        private String street;
        private String streetNumber;
        private boolean success;
        private String errorMessage;

        LocationResultBuilder() {
        }

        public LocationResultBuilder location(Location location) {
            this.location = location;
            return this;
        }

        public LocationResultBuilder address(String address) {
            this.address = address;
            return this;
        }

        public LocationResultBuilder province(String province) {
            this.province = province;
            return this;
        }

        public LocationResultBuilder city(String city) {
            this.city = city;
            return this;
        }

        public LocationResultBuilder district(String district) {
            this.district = district;
            return this;
        }

        public LocationResultBuilder street(String street) {
            this.street = street;
            return this;
        }

        public LocationResultBuilder streetNumber(String streetNumber) {
            this.streetNumber = streetNumber;
            return this;
        }

        public LocationResultBuilder success(boolean success) {
            this.success = success;
            return this;
        }

        public LocationResultBuilder errorMessage(String errorMessage) {
            this.errorMessage = errorMessage;
            return this;
        }

        public LocationResult build() {
            return new LocationResult(this.location, this.address, this.province, this.city, this.district, this.street, this.streetNumber, this.success, this.errorMessage);
        }

        public String toString() {
            return "LocationResult.LocationResultBuilder(location=" + String.valueOf(this.location) + ", address=" + this.address + ", province=" + this.province + ", city=" + this.city + ", district=" + this.district + ", street=" + this.street + ", streetNumber=" + this.streetNumber + ", success=" + this.success + ", errorMessage=" + this.errorMessage + ")";
        }
    }
}

