/*
 * Decompiled with CFR 0.152.
 */
package cn.com.anysdk.map.service;

import cn.com.anysdk.map.config.AmapConfig;
import cn.com.anysdk.map.exception.MapApiException;
import cn.com.anysdk.map.exception.MapCoordinateException;
import cn.com.anysdk.map.model.AddressResult;
import cn.com.anysdk.map.model.CoordinateType;
import cn.com.anysdk.map.model.Location;
import cn.com.anysdk.map.model.LocationResult;
import cn.com.anysdk.map.model.MapProviderType;
import cn.com.anysdk.map.service.MapService;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.IOException;
import java.net.URISyntaxException;
import java.util.HashMap;
import java.util.Map;
import org.apache.hc.client5.http.classic.methods.HttpGet;
import org.apache.hc.client5.http.impl.classic.CloseableHttpClient;
import org.apache.hc.client5.http.impl.classic.CloseableHttpResponse;
import org.apache.hc.core5.http.ClassicHttpRequest;
import org.apache.hc.core5.http.HttpEntity;
import org.apache.hc.core5.http.ParseException;
import org.apache.hc.core5.http.io.entity.EntityUtils;
import org.apache.hc.core5.net.URIBuilder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AmapService
implements MapService {
    private static final Logger log = LoggerFactory.getLogger(AmapService.class);
    private static final String BASE_URL = "https://restapi.amap.com/v3";
    private static final String GEOCODING_URL = "https://restapi.amap.com/v3/geocode/geo";
    private static final String REVERSE_GEOCODING_URL = "https://restapi.amap.com/v3/geocode/regeo";
    private static final String COORDINATE_CONVERT_URL = "https://restapi.amap.com/v3/assistant/coordinate/convert";
    private static final String STATIC_MAP_URL = "https://restapi.amap.com/v3/staticmap";
    private final AmapConfig config;
    private final CloseableHttpClient httpClient;
    private final ObjectMapper objectMapper;

    public AmapService(AmapConfig config, CloseableHttpClient httpClient) {
        this.config = config;
        this.httpClient = httpClient;
        this.objectMapper = new ObjectMapper();
    }

    @Override
    public String getStaticMapUrl(String address, int zoom) {
        try {
            log.info("\u8bf7\u6c42\u9759\u6001\u5730\u56feURL\uff0caddress: {}, zoom: {}", (Object)address, (Object)zoom);
            LocationResult locationResult = this.geocode(address);
            if (!locationResult.isSuccess()) {
                log.warn("\u5730\u5740\u89e3\u6790\u5931\u8d25: {}", (Object)locationResult.getErrorMessage());
                throw new MapApiException("\u5730\u5740\u89e3\u6790\u5931\u8d25: " + locationResult.getErrorMessage());
            }
            Location location = locationResult.getLocation();
            log.info("\u5730\u7406\u7f16\u7801\u7ed3\u679c\uff0clocation: {}", (Object)location);
            HashMap<String, Object> params = new HashMap<String, Object>();
            params.put("location", location.getLongitude() + "," + location.getLatitude());
            params.put("zoom", String.valueOf(zoom));
            params.put("size", "800*600");
            params.put("key", this.config.getAk());
            params.put("scale", "2");
            URIBuilder builder = new URIBuilder(STATIC_MAP_URL);
            params.forEach((arg_0, arg_1) -> ((URIBuilder)builder).addParameter(arg_0, arg_1));
            String url = builder.build().toString();
            log.info("\u751f\u6210\u7684\u9759\u6001\u5730\u56feURL: {}", (Object)url);
            return url;
        }
        catch (Exception e) {
            log.error("\u751f\u6210\u9759\u6001\u5730\u56feURL\u5931\u8d25, address: {}, zoom: {}", new Object[]{address, zoom, e});
            throw new MapApiException("\u751f\u6210\u9759\u6001\u5730\u56feURL\u5931\u8d25: " + e.getMessage());
        }
    }

    @Override
    public LocationResult geocode(String address) {
        try {
            log.info("\u8bf7\u6c42\u5730\u7406\u7f16\u7801, address: {}", (Object)address);
            HashMap<String, String> params = new HashMap<String, String>();
            params.put("address", address);
            params.put("output", "json");
            params.put("key", this.config.getAk());
            JsonNode response = this.doGet(GEOCODING_URL, params);
            log.debug("\u5730\u7406\u7f16\u7801API\u54cd\u5e94: {}", (Object)response);
            JsonNode geocodes = response.get("geocodes");
            if (geocodes == null || !geocodes.isArray() || geocodes.isEmpty()) {
                log.warn("\u5730\u7406\u7f16\u7801\u5931\u8d25, \u54cd\u5e94: {}", (Object)response);
                return LocationResult.error("Geocoding failed: " + response.get("info").asText());
            }
            JsonNode location = geocodes.get(0).get("location");
            String[] latLng = location.asText().split(",");
            Location resultLocation = new Location();
            resultLocation.setLatitude(Double.parseDouble(latLng[1]));
            resultLocation.setLongitude(Double.parseDouble(latLng[0]));
            resultLocation.setCoordinateType(CoordinateType.GCJ02);
            log.info("\u5730\u7406\u7f16\u7801\u6210\u529f, address: {}, location: {}", (Object)address, (Object)resultLocation);
            return LocationResult.success(resultLocation, address);
        }
        catch (Exception e) {
            log.error("Geocoding failed, address: {}", (Object)address, (Object)e);
            return LocationResult.error("Geocoding failed: " + e.getMessage());
        }
    }

    @Override
    public AddressResult reverseGeocode(Location location) {
        try {
            log.info("\u8bf7\u6c42\u9006\u5730\u7406\u7f16\u7801, location: {}", (Object)location);
            HashMap<String, String> params = new HashMap<String, String>();
            params.put("location", location.getLongitude() + "," + location.getLatitude());
            params.put("output", "json");
            params.put("key", this.config.getAk());
            JsonNode response = this.doGet(REVERSE_GEOCODING_URL, params);
            log.debug("\u9006\u5730\u7406\u7f16\u7801API\u54cd\u5e94: {}", (Object)response);
            JsonNode regeocode = response.get("regeocode");
            if (regeocode == null) {
                log.warn("\u9006\u5730\u7406\u7f16\u7801\u5931\u8d25, \u54cd\u5e94: {}", (Object)response);
                return AddressResult.error("Reverse geocoding failed: " + response.get("info").asText());
            }
            String formattedAddress = regeocode.get("formatted_address").asText();
            log.info("\u9006\u5730\u7406\u7f16\u7801\u6210\u529f, location: {}, address: {}", (Object)location, (Object)formattedAddress);
            return AddressResult.success(formattedAddress, location);
        }
        catch (Exception e) {
            log.error("Reverse geocoding failed, location: {}", (Object)location, (Object)e);
            return AddressResult.error("Reverse geocoding failed: " + e.getMessage());
        }
    }

    @Override
    public LocationResult convertCoordinate(Location location, CoordinateType fromType, CoordinateType toType) {
        try {
            log.info("\u8bf7\u6c42\u5750\u6807\u8f6c\u6362, location: {}, fromType: {}, toType: {}", new Object[]{location, fromType, toType});
            if (toType != CoordinateType.GCJ02) {
                log.warn("Amap only supports conversion to GCJ02 coordinate system, \u5f53\u524dtoType: {}", (Object)toType);
                throw new MapCoordinateException("Amap only supports conversion to GCJ02 coordinate system");
            }
            HashMap<String, String> params = new HashMap<String, String>();
            params.put("locations", location.getLongitude() + "," + location.getLatitude());
            params.put("coordsys", fromType == CoordinateType.WGS84 ? "gps" : "autonavi");
            params.put("output", "json");
            params.put("key", this.config.getAk());
            JsonNode response = this.doGet(COORDINATE_CONVERT_URL, params);
            log.debug("\u5750\u6807\u8f6c\u6362API\u54cd\u5e94: {}", (Object)response);
            JsonNode locations = response.get("locations");
            if (locations == null || !locations.isArray() || locations.isEmpty()) {
                log.warn("\u5750\u6807\u8f6c\u6362\u5931\u8d25, \u54cd\u5e94: {}", (Object)response);
                return LocationResult.error("Coordinate conversion failed: " + response.get("info").asText());
            }
            String[] latLng = locations.get(0).asText().split(",");
            Location convertedLocation = new Location();
            convertedLocation.setLatitude(Double.parseDouble(latLng[1]));
            convertedLocation.setLongitude(Double.parseDouble(latLng[0]));
            convertedLocation.setCoordinateType(CoordinateType.GCJ02);
            log.info("\u5750\u6807\u8f6c\u6362\u6210\u529f, \u539f\u59cb: {}, \u8f6c\u6362\u540e: {}", (Object)location, (Object)convertedLocation);
            return LocationResult.success(convertedLocation, null);
        }
        catch (Exception e) {
            log.error("Coordinate conversion failed, location: {}, fromType: {}, toType: {}", new Object[]{location, fromType, toType, e});
            return LocationResult.error("Coordinate conversion failed: " + e.getMessage());
        }
    }

    @Override
    public MapProviderType getProviderType() {
        return MapProviderType.AMAP;
    }

    private JsonNode doGet(String url, Map<String, String> params) throws IOException, URISyntaxException, ParseException {
        URIBuilder builder = new URIBuilder(url);
        params.forEach((arg_0, arg_1) -> ((URIBuilder)builder).addParameter(arg_0, arg_1));
        HttpGet request = new HttpGet(builder.build());
        request.setHeader("Accept", (Object)"application/json");
        log.debug("\u53d1\u8d77HTTP GET\u8bf7\u6c42, url: {}, params: {}", (Object)url, params);
        try (CloseableHttpResponse response = this.httpClient.execute((ClassicHttpRequest)request);){
            String responseBody = EntityUtils.toString((HttpEntity)response.getEntity());
            log.debug("HTTP\u54cd\u5e94\u72b6\u6001\u7801: {}, \u54cd\u5e94\u4f53: {}", (Object)response.getCode(), (Object)responseBody);
            JsonNode jsonResponse = this.objectMapper.readTree(responseBody);
            if (!"1".equals(jsonResponse.get("status").asText())) {
                log.error("Amap API error, url: {}, info: {}", (Object)url, (Object)jsonResponse.get("info").asText());
                throw new MapApiException("Amap API error: " + jsonResponse.get("info").asText(), response.getCode());
            }
            JsonNode jsonNode = jsonResponse;
            return jsonNode;
        }
    }
}

