/*
 * Decompiled with CFR 0.152.
 */
package cn.com.anysdk.map.service;

import cn.com.anysdk.map.config.BaiduMapConfig;
import cn.com.anysdk.map.exception.MapApiException;
import cn.com.anysdk.map.exception.MapCoordinateException;
import cn.com.anysdk.map.model.AddressResult;
import cn.com.anysdk.map.model.CoordinateType;
import cn.com.anysdk.map.model.Location;
import cn.com.anysdk.map.model.LocationResult;
import cn.com.anysdk.map.model.MapProviderType;
import cn.com.anysdk.map.service.MapService;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.IOException;
import java.net.URISyntaxException;
import java.util.HashMap;
import java.util.Map;
import org.apache.hc.client5.http.classic.methods.HttpGet;
import org.apache.hc.client5.http.impl.classic.CloseableHttpClient;
import org.apache.hc.client5.http.impl.classic.CloseableHttpResponse;
import org.apache.hc.core5.http.ClassicHttpRequest;
import org.apache.hc.core5.http.HttpEntity;
import org.apache.hc.core5.http.ParseException;
import org.apache.hc.core5.http.io.entity.EntityUtils;
import org.apache.hc.core5.net.URIBuilder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BaiduMapService
implements MapService {
    private static final Logger log = LoggerFactory.getLogger(BaiduMapService.class);
    private static final String BASE_URL = "https://api.map.baidu.com";
    private static final String GEOCODING_URL = "https://api.map.baidu.com/geocoding/v3/";
    private static final String REVERSE_GEOCODING_URL = "https://api.map.baidu.com/reverse_geocoding/v3/";
    private static final String COORDINATE_CONVERT_URL = "https://api.map.baidu.com/geoconv/v2/";
    private static final String STATIC_MAP_URL = "https://api.map.baidu.com/staticimage/v2";
    private final BaiduMapConfig config;
    private final CloseableHttpClient httpClient;
    private final ObjectMapper objectMapper;

    public BaiduMapService(BaiduMapConfig config, CloseableHttpClient httpClient) {
        this.config = config;
        this.httpClient = httpClient;
        this.objectMapper = new ObjectMapper();
    }

    @Override
    public String getStaticMapUrl(String address, int zoom) {
        try {
            LocationResult locationResult = this.geocode(address);
            if (!locationResult.isSuccess()) {
                log.error("Failed to get location for address: {}", (Object)address);
                return null;
            }
            Location location = locationResult.getLocation();
            HashMap<String, Object> params = new HashMap<String, Object>();
            params.put("ak", this.config.getAk());
            params.put("center", location.getLongitude() + "," + location.getLatitude());
            params.put("zoom", String.valueOf(zoom));
            params.put("width", "1024");
            params.put("height", "1024");
            params.put("markers", location.getLongitude() + "," + location.getLatitude());
            URIBuilder builder = new URIBuilder(STATIC_MAP_URL);
            params.forEach((arg_0, arg_1) -> ((URIBuilder)builder).addParameter(arg_0, arg_1));
            return builder.build().toString();
        }
        catch (Exception e) {
            log.error("Failed to generate static map URL", (Throwable)e);
            return null;
        }
    }

    @Override
    public LocationResult geocode(String address) {
        try {
            HashMap<String, String> params = new HashMap<String, String>();
            params.put("address", address);
            params.put("output", "json");
            params.put("ak", this.config.getAk());
            JsonNode response = this.doGet(GEOCODING_URL, params);
            JsonNode result = response.get("result");
            if (result == null) {
                return LocationResult.error("Geocoding failed: " + response.get("message").asText());
            }
            Location location = new Location();
            location.setLatitude(result.get("location").get("lat").asDouble());
            location.setLongitude(result.get("location").get("lng").asDouble());
            location.setCoordinateType(CoordinateType.BD09);
            return LocationResult.success(location, address);
        }
        catch (Exception e) {
            log.error("Geocoding failed", (Throwable)e);
            return LocationResult.error("Geocoding failed: " + e.getMessage());
        }
    }

    @Override
    public AddressResult reverseGeocode(Location location) {
        try {
            HashMap<String, String> params = new HashMap<String, String>();
            params.put("location", location.getLatitude() + "," + location.getLongitude());
            params.put("output", "json");
            params.put("ak", this.config.getAk());
            JsonNode response = this.doGet(REVERSE_GEOCODING_URL, params);
            JsonNode result = response.get("result");
            if (result == null) {
                return AddressResult.error("Reverse geocoding failed: " + response.get("message").asText());
            }
            return AddressResult.success(result.get("formatted_address").asText(), location);
        }
        catch (Exception e) {
            log.error("Reverse geocoding failed", (Throwable)e);
            return AddressResult.error("Reverse geocoding failed: " + e.getMessage());
        }
    }

    @Override
    public LocationResult convertCoordinate(Location location, CoordinateType fromType, CoordinateType toType) {
        try {
            if (toType != CoordinateType.BD09) {
                throw new MapCoordinateException("Baidu Map only supports conversion to BD09 coordinate system");
            }
            HashMap<String, String> params = new HashMap<String, String>();
            params.put("coords", location.getLongitude() + "," + location.getLatitude());
            params.put("from", fromType == CoordinateType.WGS84 ? "1" : "3");
            params.put("to", "5");
            params.put("output", "json");
            params.put("ak", this.config.getAk());
            JsonNode response = this.doGet(COORDINATE_CONVERT_URL, params);
            JsonNode result = response.get("result");
            if (result == null || !result.isArray() || result.isEmpty()) {
                return LocationResult.error("Coordinate conversion failed: " + response.get("message").asText());
            }
            JsonNode converted = result.get(0);
            Location convertedLocation = new Location();
            convertedLocation.setLatitude(converted.get("y").asDouble());
            convertedLocation.setLongitude(converted.get("x").asDouble());
            convertedLocation.setCoordinateType(CoordinateType.BD09);
            return LocationResult.success(convertedLocation, null);
        }
        catch (Exception e) {
            log.error("Coordinate conversion failed", (Throwable)e);
            return LocationResult.error("Coordinate conversion failed: " + e.getMessage());
        }
    }

    @Override
    public MapProviderType getProviderType() {
        return MapProviderType.BAIDU;
    }

    private JsonNode doGet(String url, Map<String, String> params) throws IOException, URISyntaxException, ParseException {
        URIBuilder builder = new URIBuilder(url);
        params.forEach((arg_0, arg_1) -> ((URIBuilder)builder).addParameter(arg_0, arg_1));
        HttpGet request = new HttpGet(builder.build());
        request.setHeader("Accept", (Object)"application/json");
        try (CloseableHttpResponse response = this.httpClient.execute((ClassicHttpRequest)request);){
            String responseBody = EntityUtils.toString((HttpEntity)response.getEntity());
            JsonNode jsonResponse = this.objectMapper.readTree(responseBody);
            if (jsonResponse.get("status").asInt() != 0) {
                throw new MapApiException("Baidu Map API error: " + jsonResponse.get("message").asText(), response.getCode());
            }
            JsonNode jsonNode = jsonResponse;
            return jsonNode;
        }
    }
}

