/*
 * Decompiled with CFR 0.152.
 */
package cn.com.anysdk.map.service;

import cn.com.anysdk.map.model.AddressResult;
import cn.com.anysdk.map.model.CoordinateType;
import cn.com.anysdk.map.model.Location;
import cn.com.anysdk.map.model.LocationResult;
import cn.com.anysdk.map.model.MapProviderType;
import cn.com.anysdk.map.service.MapService;

public class MockService
implements MapService {
    private static final double MOCK_LATITUDE = 39.908823;
    private static final double MOCK_LONGITUDE = 116.39747;
    private static final String MOCK_ADDRESS = "\u5317\u4eac\u5e02\u4e1c\u57ce\u533a\u5929\u5b89\u95e8\u5e7f\u573a";

    @Override
    public LocationResult geocode(String address) {
        Location location = new Location();
        location.setLatitude(39.908823);
        location.setLongitude(116.39747);
        location.setCoordinateType(CoordinateType.GCJ02);
        return LocationResult.success(location, address);
    }

    @Override
    public AddressResult reverseGeocode(Location location) {
        return AddressResult.success(MOCK_ADDRESS, location);
    }

    @Override
    public LocationResult convertCoordinate(Location location, CoordinateType fromType, CoordinateType toType) {
        Location convertedLocation = new Location();
        convertedLocation.setLatitude(location.getLatitude());
        convertedLocation.setLongitude(location.getLongitude());
        convertedLocation.setCoordinateType(toType);
        return LocationResult.success(convertedLocation, null);
    }

    @Override
    public MapProviderType getProviderType() {
        return MapProviderType.MOCK;
    }
}

