/*
 * Decompiled with CFR 0.152.
 */
package cn.com.anysdk.ocr.factory;

import cn.com.anysdk.ocr.config.OcrProperties;
import cn.com.anysdk.ocr.service.IOcrService;
import cn.com.anysdk.ocr.service.impl.AliyunOcrService;
import cn.com.anysdk.ocr.service.impl.MockOcrService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OcrServiceFactory {
    private static final Logger log = LoggerFactory.getLogger(OcrServiceFactory.class);

    public static IOcrService createService(OcrProperties properties) {
        String provider = properties.getProvider();
        if ("mock".equalsIgnoreCase(provider)) {
            log.info("Using MockOcrService as provider.");
            return new MockOcrService();
        }
        if ("aliyun".equalsIgnoreCase(provider)) {
            return new AliyunOcrService(properties);
        }
        log.warn("Unknown provider '{}', using MockOcrService by default.", (Object)provider);
        return new MockOcrService();
    }
}

