/*
 * Decompiled with CFR 0.152.
 */
package cn.com.anysdk.ocr.factory;

import cn.com.anysdk.ocr.exception.OcrException;
import cn.com.anysdk.ocr.monitor.OcrMonitorManager;
import cn.com.anysdk.ocr.monitor.OcrOperationContext;
import cn.com.anysdk.ocr.service.IOcrService;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OcrServiceProxyFactory {
    private static final Logger log = LoggerFactory.getLogger(OcrServiceProxyFactory.class);

    public static IOcrService createProxy(IOcrService service) {
        return (IOcrService)Proxy.newProxyInstance(service.getClass().getClassLoader(), new Class[]{IOcrService.class}, (InvocationHandler)new OcrServiceInvocationHandler(service));
    }

    private static class OcrServiceInvocationHandler
    implements InvocationHandler {
        private final IOcrService target;

        public OcrServiceInvocationHandler(IOcrService target) {
            this.target = target;
        }

        @Override
        public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
            OcrOperationContext context = OcrOperationContext.builder().provider(this.getProvider(this.target.getClass().getSimpleName())).operationType(this.getOperationType(method.getName())).build();
            try {
                Object result = method.invoke((Object)this.target, args);
                return result;
            }
            catch (Exception e) {
                Throwable cause = e.getCause();
                if (cause instanceof OcrException) {
                    OcrMonitorManager.getInstance().notifyListeners((OcrException)cause, context);
                    throw cause;
                }
                String errorMessage = String.format("OCR %s failed: %s", context.getOperationType().name().toLowerCase(), e.getMessage());
                OcrException ocrException = new OcrException(errorMessage, e);
                OcrMonitorManager.getInstance().notifyListeners(ocrException, context);
                throw ocrException;
            }
        }

        private OcrOperationContext.Provider getProvider(String className) {
            if (className.contains("Aliyun")) {
                return OcrOperationContext.Provider.ALIYUN;
            }
            if (className.contains("Tencent")) {
                return OcrOperationContext.Provider.TENCENT;
            }
            if (className.contains("Baidu")) {
                return OcrOperationContext.Provider.BAIDU;
            }
            return OcrOperationContext.Provider.LOCAL;
        }

        private OcrOperationContext.OperationType getOperationType(String methodName) {
            if (methodName.startsWith("recognize")) {
                if (methodName.contains("Batch")) {
                    return OcrOperationContext.OperationType.BATCH_RECOGNIZE;
                }
                return OcrOperationContext.OperationType.RECOGNIZE;
            }
            return null;
        }
    }
}

