/*
 * Decompiled with CFR 0.152.
 */
package cn.com.anysdk.ocr.model;

public class OcrOptions {
    private boolean detectOrientation;
    private String language;
    private String type;
    private ImagePreprocessOptions preprocessOptions;
    private int timeout;
    private RetryOptions retryOptions;

    public static OcrOptions defaultOptions() {
        return OcrOptions.builder().detectOrientation(true).language("zh").timeout(10000).type("general").preprocessOptions(ImagePreprocessOptions.builder().autoCrop(true).autoRotate(true).autoDenoise(true).autoContrast(true).build()).retryOptions(RetryOptions.builder().maxAttempts(3).retryInterval(1000L).enableExponentialBackoff(true).build()).build();
    }

    OcrOptions(boolean detectOrientation, String language, String type, ImagePreprocessOptions preprocessOptions, int timeout, RetryOptions retryOptions) {
        this.detectOrientation = detectOrientation;
        this.language = language;
        this.type = type;
        this.preprocessOptions = preprocessOptions;
        this.timeout = timeout;
        this.retryOptions = retryOptions;
    }

    public static OcrOptionsBuilder builder() {
        return new OcrOptionsBuilder();
    }

    public boolean isDetectOrientation() {
        return this.detectOrientation;
    }

    public String getLanguage() {
        return this.language;
    }

    public String getType() {
        return this.type;
    }

    public ImagePreprocessOptions getPreprocessOptions() {
        return this.preprocessOptions;
    }

    public int getTimeout() {
        return this.timeout;
    }

    public RetryOptions getRetryOptions() {
        return this.retryOptions;
    }

    public void setDetectOrientation(boolean detectOrientation) {
        this.detectOrientation = detectOrientation;
    }

    public void setLanguage(String language) {
        this.language = language;
    }

    public void setType(String type) {
        this.type = type;
    }

    public void setPreprocessOptions(ImagePreprocessOptions preprocessOptions) {
        this.preprocessOptions = preprocessOptions;
    }

    public void setTimeout(int timeout) {
        this.timeout = timeout;
    }

    public void setRetryOptions(RetryOptions retryOptions) {
        this.retryOptions = retryOptions;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof OcrOptions)) {
            return false;
        }
        OcrOptions other = (OcrOptions)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.isDetectOrientation() != other.isDetectOrientation()) {
            return false;
        }
        if (this.getTimeout() != other.getTimeout()) {
            return false;
        }
        String this$language = this.getLanguage();
        String other$language = other.getLanguage();
        if (this$language == null ? other$language != null : !this$language.equals(other$language)) {
            return false;
        }
        String this$type = this.getType();
        String other$type = other.getType();
        if (this$type == null ? other$type != null : !this$type.equals(other$type)) {
            return false;
        }
        ImagePreprocessOptions this$preprocessOptions = this.getPreprocessOptions();
        ImagePreprocessOptions other$preprocessOptions = other.getPreprocessOptions();
        if (this$preprocessOptions == null ? other$preprocessOptions != null : !((Object)this$preprocessOptions).equals(other$preprocessOptions)) {
            return false;
        }
        RetryOptions this$retryOptions = this.getRetryOptions();
        RetryOptions other$retryOptions = other.getRetryOptions();
        return !(this$retryOptions == null ? other$retryOptions != null : !((Object)this$retryOptions).equals(other$retryOptions));
    }

    protected boolean canEqual(Object other) {
        return other instanceof OcrOptions;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + (this.isDetectOrientation() ? 79 : 97);
        result = result * 59 + this.getTimeout();
        String $language = this.getLanguage();
        result = result * 59 + ($language == null ? 43 : $language.hashCode());
        String $type = this.getType();
        result = result * 59 + ($type == null ? 43 : $type.hashCode());
        ImagePreprocessOptions $preprocessOptions = this.getPreprocessOptions();
        result = result * 59 + ($preprocessOptions == null ? 43 : ((Object)$preprocessOptions).hashCode());
        RetryOptions $retryOptions = this.getRetryOptions();
        result = result * 59 + ($retryOptions == null ? 43 : ((Object)$retryOptions).hashCode());
        return result;
    }

    public String toString() {
        return "OcrOptions(detectOrientation=" + this.isDetectOrientation() + ", language=" + this.getLanguage() + ", type=" + this.getType() + ", preprocessOptions=" + String.valueOf(this.getPreprocessOptions()) + ", timeout=" + this.getTimeout() + ", retryOptions=" + String.valueOf(this.getRetryOptions()) + ")";
    }

    public static class OcrOptionsBuilder {
        private boolean detectOrientation;
        private String language;
        private String type;
        private ImagePreprocessOptions preprocessOptions;
        private int timeout;
        private RetryOptions retryOptions;

        OcrOptionsBuilder() {
        }

        public OcrOptionsBuilder detectOrientation(boolean detectOrientation) {
            this.detectOrientation = detectOrientation;
            return this;
        }

        public OcrOptionsBuilder language(String language) {
            this.language = language;
            return this;
        }

        public OcrOptionsBuilder type(String type) {
            this.type = type;
            return this;
        }

        public OcrOptionsBuilder preprocessOptions(ImagePreprocessOptions preprocessOptions) {
            this.preprocessOptions = preprocessOptions;
            return this;
        }

        public OcrOptionsBuilder timeout(int timeout) {
            this.timeout = timeout;
            return this;
        }

        public OcrOptionsBuilder retryOptions(RetryOptions retryOptions) {
            this.retryOptions = retryOptions;
            return this;
        }

        public OcrOptions build() {
            return new OcrOptions(this.detectOrientation, this.language, this.type, this.preprocessOptions, this.timeout, this.retryOptions);
        }

        public String toString() {
            return "OcrOptions.OcrOptionsBuilder(detectOrientation=" + this.detectOrientation + ", language=" + this.language + ", type=" + this.type + ", preprocessOptions=" + String.valueOf(this.preprocessOptions) + ", timeout=" + this.timeout + ", retryOptions=" + String.valueOf(this.retryOptions) + ")";
        }
    }

    public static class ImagePreprocessOptions {
        private boolean autoCrop;
        private boolean autoRotate;
        private boolean autoDenoise;
        private boolean autoContrast;

        ImagePreprocessOptions(boolean autoCrop, boolean autoRotate, boolean autoDenoise, boolean autoContrast) {
            this.autoCrop = autoCrop;
            this.autoRotate = autoRotate;
            this.autoDenoise = autoDenoise;
            this.autoContrast = autoContrast;
        }

        public static ImagePreprocessOptionsBuilder builder() {
            return new ImagePreprocessOptionsBuilder();
        }

        public boolean isAutoCrop() {
            return this.autoCrop;
        }

        public boolean isAutoRotate() {
            return this.autoRotate;
        }

        public boolean isAutoDenoise() {
            return this.autoDenoise;
        }

        public boolean isAutoContrast() {
            return this.autoContrast;
        }

        public void setAutoCrop(boolean autoCrop) {
            this.autoCrop = autoCrop;
        }

        public void setAutoRotate(boolean autoRotate) {
            this.autoRotate = autoRotate;
        }

        public void setAutoDenoise(boolean autoDenoise) {
            this.autoDenoise = autoDenoise;
        }

        public void setAutoContrast(boolean autoContrast) {
            this.autoContrast = autoContrast;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof ImagePreprocessOptions)) {
                return false;
            }
            ImagePreprocessOptions other = (ImagePreprocessOptions)o;
            if (!other.canEqual(this)) {
                return false;
            }
            if (this.isAutoCrop() != other.isAutoCrop()) {
                return false;
            }
            if (this.isAutoRotate() != other.isAutoRotate()) {
                return false;
            }
            if (this.isAutoDenoise() != other.isAutoDenoise()) {
                return false;
            }
            return this.isAutoContrast() == other.isAutoContrast();
        }

        protected boolean canEqual(Object other) {
            return other instanceof ImagePreprocessOptions;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            result = result * 59 + (this.isAutoCrop() ? 79 : 97);
            result = result * 59 + (this.isAutoRotate() ? 79 : 97);
            result = result * 59 + (this.isAutoDenoise() ? 79 : 97);
            result = result * 59 + (this.isAutoContrast() ? 79 : 97);
            return result;
        }

        public String toString() {
            return "OcrOptions.ImagePreprocessOptions(autoCrop=" + this.isAutoCrop() + ", autoRotate=" + this.isAutoRotate() + ", autoDenoise=" + this.isAutoDenoise() + ", autoContrast=" + this.isAutoContrast() + ")";
        }

        public static class ImagePreprocessOptionsBuilder {
            private boolean autoCrop;
            private boolean autoRotate;
            private boolean autoDenoise;
            private boolean autoContrast;

            ImagePreprocessOptionsBuilder() {
            }

            public ImagePreprocessOptionsBuilder autoCrop(boolean autoCrop) {
                this.autoCrop = autoCrop;
                return this;
            }

            public ImagePreprocessOptionsBuilder autoRotate(boolean autoRotate) {
                this.autoRotate = autoRotate;
                return this;
            }

            public ImagePreprocessOptionsBuilder autoDenoise(boolean autoDenoise) {
                this.autoDenoise = autoDenoise;
                return this;
            }

            public ImagePreprocessOptionsBuilder autoContrast(boolean autoContrast) {
                this.autoContrast = autoContrast;
                return this;
            }

            public ImagePreprocessOptions build() {
                return new ImagePreprocessOptions(this.autoCrop, this.autoRotate, this.autoDenoise, this.autoContrast);
            }

            public String toString() {
                return "OcrOptions.ImagePreprocessOptions.ImagePreprocessOptionsBuilder(autoCrop=" + this.autoCrop + ", autoRotate=" + this.autoRotate + ", autoDenoise=" + this.autoDenoise + ", autoContrast=" + this.autoContrast + ")";
            }
        }
    }

    public static class RetryOptions {
        private int maxAttempts;
        private long retryInterval;
        private boolean enableExponentialBackoff;

        RetryOptions(int maxAttempts, long retryInterval, boolean enableExponentialBackoff) {
            this.maxAttempts = maxAttempts;
            this.retryInterval = retryInterval;
            this.enableExponentialBackoff = enableExponentialBackoff;
        }

        public static RetryOptionsBuilder builder() {
            return new RetryOptionsBuilder();
        }

        public int getMaxAttempts() {
            return this.maxAttempts;
        }

        public long getRetryInterval() {
            return this.retryInterval;
        }

        public boolean isEnableExponentialBackoff() {
            return this.enableExponentialBackoff;
        }

        public void setMaxAttempts(int maxAttempts) {
            this.maxAttempts = maxAttempts;
        }

        public void setRetryInterval(long retryInterval) {
            this.retryInterval = retryInterval;
        }

        public void setEnableExponentialBackoff(boolean enableExponentialBackoff) {
            this.enableExponentialBackoff = enableExponentialBackoff;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof RetryOptions)) {
                return false;
            }
            RetryOptions other = (RetryOptions)o;
            if (!other.canEqual(this)) {
                return false;
            }
            if (this.getMaxAttempts() != other.getMaxAttempts()) {
                return false;
            }
            if (this.getRetryInterval() != other.getRetryInterval()) {
                return false;
            }
            return this.isEnableExponentialBackoff() == other.isEnableExponentialBackoff();
        }

        protected boolean canEqual(Object other) {
            return other instanceof RetryOptions;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            result = result * 59 + this.getMaxAttempts();
            long $retryInterval = this.getRetryInterval();
            result = result * 59 + (int)($retryInterval >>> 32 ^ $retryInterval);
            result = result * 59 + (this.isEnableExponentialBackoff() ? 79 : 97);
            return result;
        }

        public String toString() {
            return "OcrOptions.RetryOptions(maxAttempts=" + this.getMaxAttempts() + ", retryInterval=" + this.getRetryInterval() + ", enableExponentialBackoff=" + this.isEnableExponentialBackoff() + ")";
        }

        public static class RetryOptionsBuilder {
            private int maxAttempts;
            private long retryInterval;
            private boolean enableExponentialBackoff;

            RetryOptionsBuilder() {
            }

            public RetryOptionsBuilder maxAttempts(int maxAttempts) {
                this.maxAttempts = maxAttempts;
                return this;
            }

            public RetryOptionsBuilder retryInterval(long retryInterval) {
                this.retryInterval = retryInterval;
                return this;
            }

            public RetryOptionsBuilder enableExponentialBackoff(boolean enableExponentialBackoff) {
                this.enableExponentialBackoff = enableExponentialBackoff;
                return this;
            }

            public RetryOptions build() {
                return new RetryOptions(this.maxAttempts, this.retryInterval, this.enableExponentialBackoff);
            }

            public String toString() {
                return "OcrOptions.RetryOptions.RetryOptionsBuilder(maxAttempts=" + this.maxAttempts + ", retryInterval=" + this.retryInterval + ", enableExponentialBackoff=" + this.enableExponentialBackoff + ")";
            }
        }
    }
}

