/*
 * Decompiled with CFR 0.152.
 */
package cn.com.anysdk.ocr.monitor;

import cn.com.anysdk.ocr.exception.OcrException;
import cn.com.anysdk.ocr.monitor.OcrMonitorListener;
import cn.com.anysdk.ocr.monitor.OcrOperationContext;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OcrMonitorManager {
    private static final Logger log = LoggerFactory.getLogger(OcrMonitorManager.class);
    private static final OcrMonitorManager INSTANCE = new OcrMonitorManager();
    private final List<OcrMonitorListener> listeners = new CopyOnWriteArrayList<OcrMonitorListener>();

    private OcrMonitorManager() {
    }

    public static OcrMonitorManager getInstance() {
        return INSTANCE;
    }

    public void addListener(OcrMonitorListener listener) {
        if (listener != null) {
            this.listeners.add(listener);
        }
    }

    public void removeListener(OcrMonitorListener listener) {
        if (listener != null) {
            this.listeners.remove(listener);
        }
    }

    public void notifyListeners(OcrException exception, OcrOperationContext context) {
        if (exception == null || context == null) {
            return;
        }
        for (OcrMonitorListener listener : this.listeners) {
            try {
                listener.onOcrException(exception, context);
            }
            catch (Exception e) {
                log.error("Failed to notify OCR monitor listener", (Throwable)e);
            }
        }
    }

    public void clearListeners() {
        this.listeners.clear();
    }
}

