/*
 * Decompiled with CFR 0.152.
 */
package cn.com.anysdk.ocr.service.impl;

import cn.com.anysdk.ocr.config.OcrProperties;
import cn.com.anysdk.ocr.exception.OcrException;
import cn.com.anysdk.ocr.model.OcrOptions;
import cn.com.anysdk.ocr.model.OcrResult;
import cn.com.anysdk.ocr.service.IOcrService;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.aliyun.ocr_api20210707.Client;
import com.aliyun.ocr_api20210707.models.RecognizeBasicRequest;
import com.aliyun.ocr_api20210707.models.RecognizeBasicResponse;
import com.aliyun.ocr_api20210707.models.RecognizeBasicResponseBody;
import com.aliyun.teaopenapi.models.Config;
import com.aliyun.teautil.models.RuntimeOptions;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Files;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AliyunOcrService
implements IOcrService {
    private static final Logger log = LoggerFactory.getLogger(AliyunOcrService.class);
    private final OcrProperties properties;
    private final Map<String, Client> clientCache = new ConcurrentHashMap<String, Client>();

    public AliyunOcrService(OcrProperties properties) {
        log.info("AliyunOcrService \u521d\u59cb\u5316\uff0c\u914d\u7f6e\uff1a{}", (Object)properties);
        this.properties = this.validateProperties(properties);
    }

    private OcrProperties validateProperties(OcrProperties properties) {
        if (properties == null) {
            throw new OcrException("OCR properties cannot be null");
        }
        if (properties.getAliyun() == null) {
            throw new OcrException("Aliyun OCR properties cannot be null");
        }
        return properties;
    }

    private Client getClient(String type) {
        return this.clientCache.computeIfAbsent(type, this::createClient);
    }

    private Client createClient(String type) {
        try {
            OcrProperties.OcrKeyConfig config = this.getOcrConfig(type);
            if (config == null) {
                throw new OcrException("No valid OCR configuration found for type: " + type);
            }
            Config clientConfig = new Config().setAccessKeyId(config.getAccessKeyId()).setAccessKeySecret(config.getAccessKeySecret());
            Object endpoint = config.getEndpoint();
            if (endpoint == null || ((String)endpoint).trim().isEmpty()) {
                endpoint = "ocr-api." + config.getRegion() + ".aliyuncs.com";
            }
            clientConfig.endpoint = endpoint;
            return new Client(clientConfig);
        }
        catch (Exception e) {
            log.error("Failed to create Aliyun OCR client for type: {}", (Object)type, (Object)e);
            throw new OcrException("Failed to create Aliyun OCR client for type: " + type, e);
        }
    }

    private OcrProperties.OcrKeyConfig getOcrConfig(String type) {
        OcrProperties.OcrKeyConfig config = null;
        switch (type.toLowerCase()) {
            case "general": {
                config = this.properties.getAliyun().getGeneral();
                break;
            }
            case "idcard": {
                config = this.properties.getAliyun().getIdCard();
                break;
            }
            case "bankcard": {
                config = this.properties.getAliyun().getBankCard();
                break;
            }
            case "businesslicense": {
                config = this.properties.getAliyun().getBusinessLicense();
                break;
            }
            default: {
                config = this.properties.getAliyun().getGeneral();
            }
        }
        if (config == null || config.getAccessKeyId() == null || config.getAccessKeyId().trim().isEmpty() || config.getAccessKeySecret() == null || config.getAccessKeySecret().trim().isEmpty()) {
            throw new OcrException("Invalid OCR configuration for type: " + type);
        }
        return config;
    }

    @Override
    public OcrResult recognize(File file, OcrOptions options) {
        try {
            log.debug("Recognizing image from file: {}", (Object)file.getAbsolutePath());
            byte[] imageBytes = Files.readAllBytes(file.toPath());
            return this.recognize(imageBytes, options);
        }
        catch (IOException e) {
            log.error("Failed to read image file: {}", (Object)file.getAbsolutePath(), (Object)e);
            throw new OcrException("Failed to read image file: " + file.getAbsolutePath(), e);
        }
    }

    @Override
    public OcrResult recognize(InputStream inputStream, OcrOptions options) {
        try {
            log.debug("Recognizing image from input stream");
            byte[] imageBytes = inputStream.readAllBytes();
            return this.recognize(imageBytes, options);
        }
        catch (IOException e) {
            log.error("Failed to read image from input stream", (Throwable)e);
            throw new OcrException("Failed to read image from input stream", e);
        }
    }

    @Override
    public OcrResult recognize(byte[] imageBytes, OcrOptions options) {
        try {
            log.debug("Recognizing image from byte array, size: {} bytes", (Object)imageBytes.length);
            String type = options.getType() != null ? options.getType() : "general";
            Client client = this.getClient(type);
            RecognizeBasicRequest request = new RecognizeBasicRequest().setBody((InputStream)new ByteArrayInputStream(imageBytes)).setNeedRotate(Boolean.valueOf(options.isDetectOrientation()));
            RecognizeBasicResponse response = client.recognizeBasicWithOptions(request, new RuntimeOptions());
            return this.convertToOcrResult(response.getBody());
        }
        catch (Exception e) {
            log.error("Failed to recognize image from byte array", (Throwable)e);
            throw new OcrException("Failed to recognize image from byte array", e);
        }
    }

    @Override
    public OcrResult recognize(String url, OcrOptions options) {
        try {
            log.debug("Recognizing image from URL: {}", (Object)url);
            String type = options.getType() != null ? options.getType() : "general";
            Client client = this.getClient(type);
            RecognizeBasicRequest request = new RecognizeBasicRequest().setUrl(url).setNeedRotate(Boolean.valueOf(options.isDetectOrientation()));
            RecognizeBasicResponse response = client.recognizeBasicWithOptions(request, new RuntimeOptions());
            return this.convertToOcrResult(response.getBody());
        }
        catch (Exception e) {
            log.error("Failed to recognize image from URL: {}", (Object)url, (Object)e);
            throw new OcrException("Failed to recognize image from URL: " + url, e);
        }
    }

    private OcrResult convertToOcrResult(RecognizeBasicResponseBody body) {
        OcrResult result = new OcrResult();
        String dataStr = body.getData();
        if (dataStr != null && !dataStr.isEmpty()) {
            try {
                JSONObject dataJson = JSON.parseObject((String)dataStr);
                result.setText(dataJson.getString("content"));
                Float confidence = dataJson.getFloat("prism_confidence");
                if (confidence != null) {
                    result.setConfidence(confidence.floatValue());
                } else {
                    result.setConfidence(1.0);
                }
                Float orientation = dataJson.getFloat("angle");
                if (orientation != null) {
                    result.setOrientation(orientation.floatValue());
                }
                if (dataJson.containsKey((Object)"prism_wordsInfo")) {
                    result.setBlocks(null);
                }
            }
            catch (Exception e) {
                log.error("Failed to parse OCR response data: {}", (Object)dataStr, (Object)e);
                throw new OcrException("Failed to parse OCR response data", e);
            }
        }
        return result;
    }
}

