package cn.com.anysdk.ocr.config;

import cn.com.anysdk.ocr.constant.OcrConstants.Default;

/**
 * OCR 配置属性
 */
public class OcrProperties {
    /**
     * 是否启用 OCR
     */
    private boolean enabled = true;

    /**
     * 服务提供商
     */
    private String provider = Default.PROVIDER;

    /**
     * 服务端点
     */
    private String endpoint;

    /**
     * 阿里云配置
     */
    private AliyunProperties aliyun = new AliyunProperties();

    /**
     * 腾讯云配置
     */
    private TencentProperties tencent = new TencentProperties();

    /**
     * 百度云配置
     */
    private BaiduProperties baidu = new BaiduProperties();

    public boolean isEnabled() {
        return enabled;
    }

    public void setEnabled(boolean enabled) {
        this.enabled = enabled;
    }

    public String getProvider() {
        return provider;
    }

    public void setProvider(String provider) {
        this.provider = provider;
    }

    public String getEndpoint() {
        return endpoint;
    }

    public void setEndpoint(String endpoint) {
        this.endpoint = endpoint;
    }

    public AliyunProperties getAliyun() {
        return aliyun;
    }

    public void setAliyun(AliyunProperties aliyun) {
        this.aliyun = aliyun;
    }

    public TencentProperties getTencent() {
        return tencent;
    }

    public void setTencent(TencentProperties tencent) {
        this.tencent = tencent;
    }

    public BaiduProperties getBaidu() {
        return baidu;
    }

    public void setBaidu(BaiduProperties baidu) {
        this.baidu = baidu;
    }

    /**
     * 阿里云配置
     */
    public static class AliyunProperties {
        /**
         * 通用OCR配置
         */
        private OcrKeyConfig general = new OcrKeyConfig();

        /**
         * 身份证OCR配置
         */
        private OcrKeyConfig idCard = new OcrKeyConfig();

        /**
         * 银行卡OCR配置
         */
        private OcrKeyConfig bankCard = new OcrKeyConfig();

        /**
         * 营业执照OCR配置
         */
        private OcrKeyConfig businessLicense = new OcrKeyConfig();

        public OcrKeyConfig getGeneral() {
            return general;
        }

        public void setGeneral(OcrKeyConfig general) {
            this.general = general;
        }

        public OcrKeyConfig getIdCard() {
            return idCard;
        }

        public void setIdCard(OcrKeyConfig idCard) {
            this.idCard = idCard;
        }

        public OcrKeyConfig getBankCard() {
            return bankCard;
        }

        public void setBankCard(OcrKeyConfig bankCard) {
            this.bankCard = bankCard;
        }

        public OcrKeyConfig getBusinessLicense() {
            return businessLicense;
        }

        public void setBusinessLicense(OcrKeyConfig businessLicense) {
            this.businessLicense = businessLicense;
        }
    }

    /**
     * OCR密钥配置
     */
    public static class OcrKeyConfig {
        /**
         * 访问密钥 ID
         */
        private String accessKeyId;

        /**
         * 访问密钥密码
         */
        private String accessKeySecret;

        /**
         * 区域
         */
        private String region;

        /**
         * 服务端点
         */
        private String endpoint;

        public String getAccessKeyId() {
            return accessKeyId;
        }

        public void setAccessKeyId(String accessKeyId) {
            this.accessKeyId = accessKeyId;
        }

        public String getAccessKeySecret() {
            return accessKeySecret;
        }

        public void setAccessKeySecret(String accessKeySecret) {
            this.accessKeySecret = accessKeySecret;
        }

        public String getRegion() {
            return region;
        }

        public void setRegion(String region) {
            this.region = region;
        }

        public String getEndpoint() {
            return endpoint;
        }

        public void setEndpoint(String endpoint) {
            this.endpoint = endpoint;
        }
    }

    /**
     * 腾讯云配置
     */
    public static class TencentProperties {
        /**
         * 访问密钥 ID
         */
        private String secretId;

        /**
         * 访问密钥密码
         */
        private String secretKey;

        /**
         * 区域
         */
        private String region = "ap-guangzhou";

        public String getSecretId() {
            return secretId;
        }

        public void setSecretId(String secretId) {
            this.secretId = secretId;
        }

        public String getSecretKey() {
            return secretKey;
        }

        public void setSecretKey(String secretKey) {
            this.secretKey = secretKey;
        }

        public String getRegion() {
            return region;
        }

        public void setRegion(String region) {
            this.region = region;
        }
    }

    /**
     * 百度云配置
     */
    public static class BaiduProperties {
        /**
         * API Key
         */
        private String apiKey;

        /**
         * Secret Key
         */
        private String secretKey;

        public String getApiKey() {
            return apiKey;
        }

        public void setApiKey(String apiKey) {
            this.apiKey = apiKey;
        }

        public String getSecretKey() {
            return secretKey;
        }

        public void setSecretKey(String secretKey) {
            this.secretKey = secretKey;
        }
    }
}

