package cn.com.anysdk.ocr.constant;

/**
 * OCR 相关常量
 */
public class OcrConstants {
    /**
     * OCR 服务提供商
     */
    public static final class Provider {
        public static final String ALIYUN = "aliyun";
        public static final String TENCENT = "tencent";
        public static final String BAIDU = "baidu";
    }

    /**
     * OCR 语言类型
     */
    public static final class Language {
        public static final String CHINESE = "zh";
        public static final String ENGLISH = "en";
        public static final String CHINESE_ENGLISH = "zh_en";
    }

    /**
     * OCR 识别类型
     */
    public static final class Type {
        public static final String GENERAL = "general";      // 通用文字识别
        public static final String ID_CARD = "id_card";      // 身份证识别
        public static final String BANK_CARD = "bank_card";  // 银行卡识别
        public static final String INVOICE = "invoice";      // 发票识别
        public static final String TABLE = "table";          // 表格识别
    }

    /**
     * OCR 配置前缀
     */
    public static final String CONFIG_PREFIX = "anysdk.ocr";

    /**
     * OCR 默认配置
     */
    public static final class Default {
        public static final String PROVIDER = Provider.ALIYUN;
        public static final String LANGUAGE = Language.CHINESE;
        public static final String TYPE = Type.GENERAL;
        public static final boolean DETECT_ORIENTATION = true;
        public static final boolean RETURN_CONFIDENCE = true;
        public static final boolean RETURN_BLOCK = true;
        public static final boolean RETURN_WORD = false;
    }
}