package cn.com.anysdk.ocr.enums;

import cn.com.anysdk.ocr.constant.OcrConstants.Provider;

/**
 * OCR 服务提供商枚举
 */
public enum OcrProvider {
    ALIYUN(Provider.ALIYUN, "阿里云 OCR"),
    TENCENT(Provider.TENCENT, "腾讯云 OCR"),
    BAIDU(Provider.BAIDU, "百度云 OCR");

    private final String code;
    private final String description;

    OcrProvider(String code, String description) {
        this.code = code;
        this.description = description;
    }

    public String getCode() {
        return code;
    }

    public String getDescription() {
        return description;
    }

    public static OcrProvider fromCode(String code) {
        for (OcrProvider provider : values()) {
            if (provider.getCode().equals(code)) {
                return provider;
            }
        }
        throw new IllegalArgumentException("Unknown OCR provider code: " + code);
    }
}