package cn.com.anysdk.ocr.exception;

import cn.com.anysdk.ocr.model.OcrResult;
import lombok.extern.slf4j.Slf4j;

/**
 * OCR 异常处理器
 */
@Slf4j
public class OcrExceptionHandler {
    /**
     * 处理异常
     *
     * @param e 异常
     * @return OCR 结果
     */
    public static OcrResult handle(Exception e) {
        if (e instanceof OcrException) {
            log.error("OCR 异常: {}", e.getMessage());
            return createErrorResult(e.getMessage());
        } else {
            log.error("OCR 未知异常", e);
            return createErrorResult("OCR 服务异常");
        }
    }

    /**
     * 创建错误结果
     *
     * @param message 错误信息
     * @return OCR 结果
     */
    private static OcrResult createErrorResult(String message) {
        OcrResult result = new OcrResult();
        result.setText(message);
        result.setConfidence(0.0);
        return result;
    }
}