package cn.com.anysdk.ocr.factory;

import cn.com.anysdk.ocr.config.OcrProperties;
import cn.com.anysdk.ocr.service.IOcrService;
import cn.com.anysdk.ocr.service.impl.AliyunOcrService;
import cn.com.anysdk.ocr.service.impl.MockOcrService;
import lombok.extern.slf4j.Slf4j;

@Slf4j
public class OcrServiceFactory {
    public static IOcrService createService(OcrProperties properties) {
        String provider = properties.getProvider();
        if ("mock".equalsIgnoreCase(provider)) {
            log.info("Using MockOcrService as provider.");
            return new MockOcrService();
        } else if ("aliyun".equalsIgnoreCase(provider)) {
            return new AliyunOcrService(properties);
        }
        log.warn("Unknown provider '{}', using MockOcrService by default.", provider);
        return new MockOcrService();
    }
}
