package cn.com.anysdk.ocr.model;

import lombok.Data;
import lombok.Builder;

/**
 * OCR 识别选项
 */
@Data
@Builder
public class OcrOptions {
    /**
     * 是否检测图片方向
     */
    private boolean detectOrientation;

    /**
     * 识别语言，支持：
     * - zh：中文
     * - en：英文
     * - zh_en：中英文混合
     */
    private String language;

    /**
     * 识别类型，支持：
     * - general：通用文字识别
     * - id_card：身份证识别
     * - bank_card：银行卡识别
     * - invoice：发票识别
     * - table：表格识别
     */
    private String type;

    /**
     * 图片预处理选项
     */
    private ImagePreprocessOptions preprocessOptions;

    /**
     * 请求超时时间（毫秒）
     */
    private int timeout;

    /**
     * 重试配置
     */
    private RetryOptions retryOptions;

    @Data
    @Builder
    public static class ImagePreprocessOptions {
        /**
         * 是否自动裁剪
         */
        private boolean autoCrop;

        /**
         * 是否自动旋转
         */
        private boolean autoRotate;

        /**
         * 是否自动去噪
         */
        private boolean autoDenoise;

        /**
         * 是否自动增强对比度
         */
        private boolean autoContrast;
    }

    @Data
    @Builder
    public static class RetryOptions {
        /**
         * 最大重试次数
         */
        private int maxAttempts;

        /**
         * 重试间隔（毫秒）
         */
        private long retryInterval;

        /**
         * 是否启用指数退避
         */
        private boolean enableExponentialBackoff;
    }

    /**
     * 创建默认选项
     */
    public static OcrOptions defaultOptions() {
        return OcrOptions.builder()
                .detectOrientation(true)
                .language("zh")
                .timeout(10000)
                .type("general")
                .preprocessOptions(ImagePreprocessOptions.builder()
                        .autoCrop(true)
                        .autoRotate(true)
                        .autoDenoise(true)
                        .autoContrast(true)
                        .build())
                .retryOptions(RetryOptions.builder()
                        .maxAttempts(3)
                        .retryInterval(1000)
                        .enableExponentialBackoff(true)
                        .build())
                .build();
    }
}