package cn.com.anysdk.ocr.model;

import java.util.ArrayList;
import java.util.List;

/**
 * OCR 识别结果
 */
public class OcrResult {
    /**
     * 完整文本
     */
    private String text;

    /**
     * 版块列表
     */
    private List<OcrBlock> blocks = new ArrayList<>();

    /**
     * 置信度
     */
    private double confidence;

    /**
     * 图片方向
     */
    private float orientation;

    public String getText() {
        return text;
    }

    public OcrResult setText(String text) {
        this.text = text;
        return this;
    }

    public List<OcrBlock> getBlocks() {
        return blocks;
    }

    public OcrResult setBlocks(List<OcrBlock> blocks) {
        this.blocks = blocks;
        return this;
    }

    public double getConfidence() {
        return confidence;
    }

    public OcrResult setConfidence(double confidence) {
        this.confidence = confidence;
        return this;
    }

    public float getOrientation() {
        return orientation;
    }

    public OcrResult setOrientation(float orientation) {
        this.orientation = orientation;
        return this;
    }

    /**
     * OCR 版块
     */
    public static class OcrBlock {
        /**
         * 版块文本
         */
        private String text;

        /**
         * 版块类型
         */
        private String type;

        /**
         * 版块位置
         */
        private Box box;

        /**
         * 置信度
         */
        private double confidence;

        /**
         * 行列表
         */
        private List<OcrLine> lines = new ArrayList<>();

        public String getText() {
            return text;
        }

        public OcrBlock setText(String text) {
            this.text = text;
            return this;
        }

        public String getType() {
            return type;
        }

        public OcrBlock setType(String type) {
            this.type = type;
            return this;
        }

        public Box getBox() {
            return box;
        }

        public OcrBlock setBox(Box box) {
            this.box = box;
            return this;
        }

        public double getConfidence() {
            return confidence;
        }

        public OcrBlock setConfidence(double confidence) {
            this.confidence = confidence;
            return this;
        }

        public List<OcrLine> getLines() {
            return lines;
        }

        public OcrBlock setLines(List<OcrLine> lines) {
            this.lines = lines;
            return this;
        }
    }

    /**
     * OCR 行
     */
    public static class OcrLine {
        /**
         * 行文本
         */
        private String text;

        /**
         * 行位置
         */
        private Box box;

        /**
         * 置信度
         */
        private double confidence;

        /**
         * 单词列表
         */
        private List<OcrWord> words = new ArrayList<>();

        public String getText() {
            return text;
        }

        public OcrLine setText(String text) {
            this.text = text;
            return this;
        }

        public Box getBox() {
            return box;
        }

        public OcrLine setBox(Box box) {
            this.box = box;
            return this;
        }

        public double getConfidence() {
            return confidence;
        }

        public OcrLine setConfidence(double confidence) {
            this.confidence = confidence;
            return this;
        }

        public List<OcrWord> getWords() {
            return words;
        }

        public OcrLine setWords(List<OcrWord> words) {
            this.words = words;
            return this;
        }
    }

    /**
     * OCR 单词
     */
    public static class OcrWord {
        /**
         * 单词文本
         */
        private String text;

        /**
         * 单词位置
         */
        private Box box;

        /**
         * 置信度
         */
        private double confidence;

        public String getText() {
            return text;
        }

        public OcrWord setText(String text) {
            this.text = text;
            return this;
        }

        public Box getBox() {
            return box;
        }

        public OcrWord setBox(Box box) {
            this.box = box;
            return this;
        }

        public double getConfidence() {
            return confidence;
        }

        public OcrWord setConfidence(double confidence) {
            this.confidence = confidence;
            return this;
        }
    }

    /**
     * 位置信息
     */
    public static class Box {
        /**
         * 左上角 x 坐标
         */
        private int x;

        /**
         * 左上角 y 坐标
         */
        private int y;

        /**
         * 宽度
         */
        private int width;

        /**
         * 高度
         */
        private int height;

        public int getX() {
            return x;
        }

        public Box setX(int x) {
            this.x = x;
            return this;
        }

        public int getY() {
            return y;
        }

        public Box setY(int y) {
            this.y = y;
            return this;
        }

        public int getWidth() {
            return width;
        }

        public Box setWidth(int width) {
            this.width = width;
            return this;
        }

        public int getHeight() {
            return height;
        }

        public Box setHeight(int height) {
            this.height = height;
            return this;
        }
    }
}