package cn.com.anysdk.ocr.monitor;

import lombok.Builder;
import lombok.Data;

/**
 * OCR 操作上下文
 */
@Data
@Builder
public class OcrOperationContext {
    /**
     * 提供商
     */
    private Provider provider;

    /**
     * 操作类型
     */
    private OperationType operationType;

    /**
     * OCR 提供商
     */
    public enum Provider {
        /**
         * 阿里云
         */
        ALIYUN,
        /**
         * 腾讯云
         */
        TENCENT,
        /**
         * 百度云
         */
        BAIDU,
        /**
         * 本地
         */
        LOCAL
    }

    /**
     * OCR 操作类型
     */
    public enum OperationType {
        /**
         * 单张识别
         */
        RECOGNIZE,
        /**
         * 批量识别
         */
        BATCH_RECOGNIZE
    }
}