package cn.com.anysdk.ocr.service;

import cn.com.anysdk.ocr.model.OcrOptions;
import cn.com.anysdk.ocr.model.OcrResult;

import java.io.File;
import java.io.InputStream;
import java.util.List;

/**
 * OCR 服务接口
 */
public interface IOcrService {
    /**
     * 识别图片文件
     *
     * @param file    图片文件
     * @param options 识别选项
     * @return 识别结果
     */
    OcrResult recognize(File file, OcrOptions options);

    /**
     * 识别图片输入流
     *
     * @param inputStream 图片输入流
     * @param options     识别选项
     * @return 识别结果
     */
    OcrResult recognize(InputStream inputStream, OcrOptions options);

    /**
     * 识别图片字节数组
     *
     * @param imageBytes 图片字节数组
     * @param options    识别选项
     * @return 识别结果
     */
    OcrResult recognize(byte[] imageBytes, OcrOptions options);

    /**
     * 识别图片 URL
     *
     * @param url     图片 URL
     * @param options 识别选项
     * @return 识别结果
     */
    OcrResult recognize(String url, OcrOptions options);
}