package cn.com.anysdk.ocr.service.impl;

import cn.com.anysdk.ocr.model.OcrOptions;
import cn.com.anysdk.ocr.model.OcrResult;
import cn.com.anysdk.ocr.service.IOcrService;
import lombok.extern.slf4j.Slf4j;

import java.io.File;
import java.io.InputStream;



@Slf4j
public class MockOcrService implements IOcrService {

    @Override
    public OcrResult recognize(File file, OcrOptions options) {
        return createMockResult();
    }

    @Override
    public OcrResult recognize(InputStream inputStream, OcrOptions options) {
        return createMockResult();
    }

    @Override
    public OcrResult recognize(byte[] imageBytes, OcrOptions options) {
        return createMockResult();
    }

    @Override
    public OcrResult recognize(String url, OcrOptions options) {
        return createMockResult();
    }

    private OcrResult createMockResult() {
        OcrResult result = new OcrResult();
        result.setText("This is a mock OCR result.");
        result.setConfidence(0.99f);
        result.setOrientation(0.0f);
        return result;
    }
}