package cn.com.anysdk.oss.api;

/**
 * OSS配置接口
 * 定义了OSS服务所需的基本配置项
 */
public interface IOssConfig {
    /**
     * 获取访问密钥ID
     */
    String getAccessKeyId();

    /**
     * 获取访问密钥密码
     */
    String getAccessKeySecret();

    /**
     * 获取存储桶名称
     */
    String getBucketName();

    /**
     * 获取endpoint地址
     */
    String getEndpoint();

    /**
     * 是否使用内网endpoint
     */
    boolean isIntranet();

    /**
     * 获取自定义域名
     */
    String getCustomDomain();

    /**
     * 是否开启私有访问模式
     */
    boolean isPrivateMode();

    /**
     * 获取存储服务提供商
     * @return 存储服务提供商名称
     */
    String getProvider();
}