package cn.com.anysdk.oss.api;

import java.io.File;
import java.io.InputStream;
import java.util.List;

/**
 * OSS服务接口
 * 定义了OSS服务的核心操作方法
 */
public interface IOssService {
    /**
     * 上传文件
     * @param objectKey 对象键
     * @param file 文件
     * @return 文件访问URL
     */
    String uploadFile(String objectKey, File file);

    /**
     * 上传文件流
     * @param objectKey 对象键
     * @param inputStream 输入流
     * @param size 文件大小
     * @return 文件访问URL
     */
    String uploadFile(String objectKey, InputStream inputStream, long size);

    /**
     * 带选项上传文件
     * @param objectKey 对象键
     * @param file 文件
     * @param options 上传选项
     * @return 文件访问URL
     */
    String uploadFile(String objectKey, File file, UploadOptions options);

    /**
     * 下载文件
     * @param objectKey 对象键
     * @return 文件输入流
     */
    InputStream downloadFile(String objectKey);

    /**
     * 删除文件
     * @param objectKey 对象键
     */
    void deleteFile(String objectKey);

    /**
     * 批量删除文件
     * @param objectKeys 对象键列表
     */
    void deleteFiles(List<String> objectKeys);

    /**
     * 获取文件访问URL
     * @param objectKey 对象键
     * @return 文件访问URL
     */
    String getFileUrl(String objectKey);

    /**
     * 获取带签名的临时访问URL
     * @param objectKey 对象键
     * @param expireSeconds 过期时间（秒）
     * @return 带签名的临时访问URL
     */
    String getSignedUrl(String objectKey, long expireSeconds);

    /**
     * 判断文件是否存在
     * @param objectKey 对象键
     * @return 是否存在
     */
    boolean doesObjectExist(String objectKey);

    /**
     * 获取当前服务商配置
     * @return 当前服务商配置
     */
    IOssConfig getConfig();

    /**
     * 验证当前配置是否有效
     * @return 配置是否有效
     */
    boolean validateConfig();
}