package cn.com.anysdk.oss.api;

import cn.com.anysdk.oss.exception.OssException;
import cn.com.anysdk.oss.monitor.OssOperationContext;

/**
 * OSS异常监听器接口
 * 用于监听和处理OSS操作过程中的异常
 */
public interface OssExceptionListener {
    /**
     * 当发生异常时调用
     *
     * @param exception 异常信息
     * @param context 操作上下文
     */
    void onException(OssException exception, OssOperationContext context);
}