package cn.com.anysdk.oss.config;

import cn.com.anysdk.oss.api.IOssConfig;
import com.aliyun.oss.OSS;
import com.aliyun.oss.OSSClientBuilder;
import lombok.Builder;
import lombok.Data;

@Data
@Builder
public class AliyunOssConfig implements IOssConfig {

    private String endpoint;
    private String accessKeyId;
    private String accessKeySecret;
    private String bucketName;
    private boolean isPrivate;
    private boolean isIntranet;
    private String customDomain;

    public OSS createOssClient() {
        return new OSSClientBuilder().build(endpoint, accessKeyId, accessKeySecret);
    }


    @Override
    public String getAccessKeyId() {
        return accessKeyId;
    }

    @Override
    public String getAccessKeySecret() {
        return accessKeySecret;
    }

    @Override
    public String getBucketName() {
        return bucketName;
    }

    @Override
    public String getEndpoint() {
        return endpoint;
    }

    @Override
    public boolean isIntranet() {
        return isIntranet;
    }

    @Override
    public String getCustomDomain() {
        return customDomain;
    }

    @Override
    public boolean isPrivateMode() {
        return isPrivate;
    }

    @Override
    public String getProvider() {
        return "aliyun";
    }
}
