package cn.com.anysdk.oss.config;

import cn.com.anysdk.oss.api.IOssConfig;
import lombok.Data;

@Data
public class LocalFileSystemConfig implements IOssConfig {
    /**
     * 本地文件系统的基础路径
     */
    private String basePath;
    private boolean isPrivate;
    private boolean isIntranet;
    private String customDomain;

    @Override
    public String getAccessKeyId() {
        return null;
    }

    @Override
    public String getAccessKeySecret() {
        return null;
    }

    @Override
    public String getBucketName() {
        return basePath;
    }

    @Override
    public String getEndpoint() {
        return "file://" + basePath;
    }

    @Override
    public boolean isIntranet() {
        return isIntranet;
    }

    @Override
    public String getCustomDomain() {
        return customDomain;
    }

    @Override
    public boolean isPrivateMode() {
        return isPrivate;
    }

    @Override
    public String getProvider() {
        return "local";
    }
}