package cn.com.anysdk.oss.config;

import cn.com.anysdk.oss.api.IOssConfig;
import io.minio.MinioClient;
import lombok.Builder;
import lombok.Data;
import lombok.Getter;

@Data
@Builder
public class MinioConfig implements IOssConfig {
    private String endpoint;
    private String accessKeyId;
    private String accessKeySecret;
    private String bucketName;
    private boolean isPrivate;
    private boolean isIntranet;
    private String customDomain;

    public MinioClient createMinioClient() {
        return MinioClient.builder()
                .endpoint(endpoint)
                .credentials(accessKeyId, accessKeySecret)
                .build();
    }

    @Override
    public String getAccessKeyId() {
        return accessKeyId;
    }

    @Override
    public String getAccessKeySecret() {
        return accessKeySecret;
    }

    @Override
    public String getBucketName() {
        return bucketName;
    }

    @Override
    public String getEndpoint() {
        return endpoint;
    }

    @Override
    public boolean isIntranet() {
        return isIntranet;
    }

    @Override
    public String getCustomDomain() {
        return customDomain;
    }

    @Override
    public boolean isPrivateMode() {
        return isPrivate;
    }

    @Override
    public String getProvider() {
        return "minio";
    }
}